DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE `#__assets` (
`id` int(10) unsigned NOT NULL COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.'
)  AUTO_INCREMENT=374 DEFAULT CHARSET=utf8;

--
-- Daten für Tabelle `#__assets`
--

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 1, 636, 0, 'root.1', 'Root Asset', '{"core.login.site":{"6":1,"2":1},"core.login.admin":{"6":1},"core.login.offline":[],"core.admin":{"8":1},"core.manage":{"7":1},"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(2, 1, 1, 2, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 3, 6, 1, 'com_banners', 'com_banners', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(4, 1, 7, 8, 1, 'com_cache', 'com_cache', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(5, 1, 9, 10, 1, 'com_checkin', 'com_checkin', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(6, 1, 11, 12, 1, 'com_config', 'com_config', '{}'),
(7, 1, 13, 18, 1, 'com_contact', 'com_contact', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(8, 1, 19, 112, 1, 'com_content', 'com_content', '{"core.admin":{"7":1},"core.options":[],"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(9, 1, 113, 114, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 115, 116, 1, 'com_installer', 'com_installer', '{"core.admin":{"7":1},"core.manage":{"7":1},"core.delete":[],"core.edit.state":[]}'),
(11, 1, 117, 118, 1, 'com_languages', 'com_languages', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(12, 1, 119, 120, 1, 'com_login', 'com_login', '{}'),
(13, 1, 121, 122, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 123, 124, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 125, 126, 1, 'com_media', 'com_media', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":{"5":1}}'),
(16, 1, 127, 128, 1, 'com_menus', 'com_menus', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(17, 1, 129, 130, 1, 'com_messages', 'com_messages', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(18, 1, 131, 268, 1, 'com_modules', 'com_modules', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(19, 1, 269, 272, 1, 'com_newsfeeds', 'com_newsfeeds', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(20, 1, 273, 274, 1, 'com_plugins', 'com_plugins', '{"core.admin":{"7":1},"core.manage":[],"core.edit":[],"core.edit.state":[]}'),
(21, 1, 275, 276, 1, 'com_redirect', 'com_redirect', '{"core.admin":{"7":1},"core.manage":[]}'),
(22, 1, 277, 278, 1, 'com_search', 'com_search', '{"core.admin":{"7":1},"core.manage":{"6":1}}'),
(26, 1, 279, 280, 1, 'com_wrapper', 'com_wrapper', '{}'),
(27, 8, 20, 61, 2, 'com_content.category.2', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(28, 3, 4, 5, 2, 'com_banners.category.3', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(29, 7, 14, 15, 2, 'com_contact.category.4', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(30, 19, 270, 271, 2, 'com_newsfeeds.category.5', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(32, 8, 62, 89, 2, 'com_content.category.7', 'Blog', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(33, 27, 21, 22, 3, 'com_content.article.1', 'Layouts', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(36, 27, 25, 26, 3, 'com_content.article.4', 'UIkit', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(37, 27, 27, 28, 3, 'com_content.article.5', 'Dummy Content', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(38, 27, 29, 30, 3, 'com_content.article.6', 'Theme', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(39, 27, 31, 32, 3, 'com_content.article.7', 'Home', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(40, 32, 63, 64, 3, 'com_content.article.8', 'Joomla Templates', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(41, 32, 65, 66, 3, 'com_content.article.9', 'Beautiful Icons', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(42, 32, 67, 68, 3, 'com_content.article.10', 'Warp Framework', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(43, 32, 69, 70, 3, 'com_content.article.11', 'ZOO Extension', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(56, 7, 16, 17, 2, 'com_contact.category.8', 'Contacts', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(59, 1, 576, 577, 1, 'com_finder', 'com_finder', '{"core.admin":[],"core.manage":[]}'),
(63, 1, 580, 581, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{"core.admin":{"8":1},"core.manage":{"7":1},"core.delete":{"6":1},"core.edit.state":{"6":1,"5":1}}'),
(65, 1, 582, 583, 1, '#__ucm_content.1', '#__ucm_content.1', '[]'),
(66, 1, 584, 585, 1, '#__ucm_content.2', '#__ucm_content.2', '[]'),
(67, 1, 586, 587, 1, '#__ucm_content.3', '#__ucm_content.3', '[]'),
(68, 1, 588, 589, 1, '#__ucm_content.4', '#__ucm_content.4', '[]'),
(69, 1, 590, 591, 1, '#__ucm_content.5', '#__ucm_content.5', '[]'),
(70, 1, 592, 593, 1, '#__ucm_content.6', '#__ucm_content.6', '[]'),
(71, 1, 594, 595, 1, 'com_tags', 'com_tags', '{}'),
(72, 1, 596, 597, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(73, 1, 598, 599, 1, 'com_ajax', 'com_ajax', '{}'),
(74, 1, 600, 601, 1, 'com_postinstall', 'com_postinstall', '{}'),
(76, 18, 270, 271, 2, 'com_modules.module.17', 'Breadcrumbs', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(77, 18, 272, 273, 2, 'com_modules.module.19', 'Bottom A', '{}'),
(78, 18, 274, 275, 2, 'com_modules.module.20', 'Bottom A', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(79, 18, 276, 277, 2, 'com_modules.module.21', 'Bottom A', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(85, 18, 278, 279, 2, 'com_modules.module.27', 'Bottom B', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(86, 18, 280, 281, 2, 'com_modules.module.28', 'Bottom B', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(87, 18, 282, 283, 2, 'com_modules.module.29', 'Bottom B', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(88, 18, 284, 285, 2, 'com_modules.module.30', 'Bottom B', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(92, 18, 286, 287, 2, 'com_modules.module.34', 'Main Bottom', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(93, 18, 288, 289, 2, 'com_modules.module.35', 'Main Bottom', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(94, 18, 290, 291, 2, 'com_modules.module.36', ' Main Top', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(95, 18, 292, 293, 2, 'com_modules.module.37', 'Main Top', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(96, 18, 294, 295, 2, 'com_modules.module.38', 'Logo', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(98, 18, 296, 297, 2, 'com_modules.module.40', 'Search', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(100, 18, 298, 299, 2, 'com_modules.module.42', 'Sidebar Menu', ''),
(101, 18, 300, 301, 2, 'com_modules.module.43', 'Sidebar A', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(102, 18, 302, 303, 2, 'com_modules.module.44', 'Sidebar A', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(109, 18, 304, 305, 2, 'com_modules.module.57', 'Sidebar B', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(110, 18, 306, 307, 2, 'com_modules.module.58', 'Sidebar B', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(111, 18, 308, 309, 2, 'com_modules.module.59', 'Sidebar B', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(112, 18, 310, 311, 2, 'com_modules.module.61', 'Footer Menu', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(113, 18, 312, 313, 2, 'com_modules.module.62', 'Top A', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(114, 18, 314, 315, 2, 'com_modules.module.63', 'Top A', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(115, 18, 316, 317, 2, 'com_modules.module.64', 'Top A', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(116, 18, 318, 319, 2, 'com_modules.module.65', 'Top A', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(122, 18, 320, 321, 2, 'com_modules.module.71', 'Top B', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(123, 18, 322, 323, 2, 'com_modules.module.72', 'Top B', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(124, 18, 324, 325, 2, 'com_modules.module.73', 'Top B', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(131, 18, 328, 329, 2, 'com_modules.module.82', 'Finder', ''),
(132, 18, 330, 331, 2, 'com_modules.module.83', 'ZOO Item', ''),
(133, 18, 332, 333, 2, 'com_modules.module.84', 'ZOO Comment', ''),
(134, 18, 334, 335, 2, 'com_modules.module.85', 'ZOO Tag', ''),
(135, 18, 336, 337, 2, 'com_modules.module.86', 'ZOO Category', ''),
(136, 18, 338, 339, 2, 'com_modules.module.88', 'App Bundle', ''),
(141, 18, 340, 341, 2, 'com_modules.module.94', 'Offcanvas Menu', ''),
(142, 18, 342, 343, 2, 'com_modules.module.95', 'Offcanvas', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(146, 18, 344, 345, 2, 'com_modules.module.99', 'UIkit Intro', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(149, 18, 346, 347, 2, 'com_modules.module.102', 'Logo small', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(151, 32, 77, 78, 3, 'com_content.article.24', 'UIkit Framework', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(152, 1, 602, 603, 1, '#__ucm_content.7', '#__ucm_content.7', '[]'),
(153, 32, 79, 80, 3, 'com_content.article.25', 'Pagekit CMS', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(154, 1, 604, 605, 1, '#__ucm_content.8', '#__ucm_content.8', '[]'),
(156, 32, 83, 84, 3, 'com_content.article.26', 'Free Halloween Icons', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(157, 1, 606, 607, 1, '#__ucm_content.9', '#__ucm_content.9', '[]'),
(158, 1, 608, 609, 1, 'com_widgetkit', 'com_widgetkit', '{}'),
(159, 27, 45, 46, 3, 'com_content.article.13', 'Widgetkit', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(163, 18, 132, 133, 2, 'com_modules.module.106', 'Widgetkit Intro', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(165, 27, 47, 48, 3, 'com_content.article.28', 'Gallery', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(169, 18, 134, 135, 2, 'com_modules.module.107', 'Features Split', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(190, 8, 90, 109, 2, 'com_content.category.10', 'Blog Dynamic', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(200, 27, 49, 50, 3, 'com_content.article.41', 'Blog Dynamic', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(201, 18, 136, 137, 2, 'com_modules.module.128', 'Our blog', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(205, 18, 138, 139, 2, 'com_modules.module.132', 'Theme Features', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(206, 32, 85, 86, 3, 'com_content.article.23', 'Widgetkit', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(211, 8, 110, 111, 2, 'com_content.category.11', 'Blog Alternate', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(215, 18, 140, 141, 2, 'com_modules.module.136', 'Widgetkit Download', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(217, 18, 142, 143, 2, 'com_modules.module.138', 'Top C', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(218, 18, 144, 145, 2, 'com_modules.module.139', 'Top C', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(219, 18, 146, 147, 2, 'com_modules.module.140', 'Top C', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(220, 18, 148, 149, 2, 'com_modules.module.141', 'Bottom C', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(222, 18, 150, 151, 2, 'com_modules.module.143', 'Bottom C', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(223, 18, 152, 153, 2, 'com_modules.module.144', 'Bottom C', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(224, 18, 154, 155, 2, 'com_modules.module.145', 'Bottom C', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(234, 18, 156, 157, 2, 'com_modules.module.155', 'Home Header Slideshow', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(247, 27, 51, 52, 3, 'com_content.article.46', 'Portfolio', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(248, 27, 53, 54, 3, 'com_content.article.47', 'Services', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(249, 27, 55, 56, 3, 'com_content.article.48', 'Get in touch', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(266, 18, 158, 159, 2, 'com_modules.module.184', 'Our Address', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(271, 32, 87, 88, 3, 'com_content.article.49', 'Avanti Theme is here', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(283, 18, 160, 161, 2, 'com_modules.module.200', 'Blog Slideset', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(289, 18, 162, 163, 2, 'com_modules.module.206', 'Theme Styles', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(290, 18, 164, 165, 2, 'com_modules.module.207', 'Featured Technologies', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(294, 18, 166, 167, 2, 'com_modules.module.211', 'Search', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(295, 27, 57, 58, 3, 'com_content.article.50', 'Search', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(297, 18, 168, 169, 2, 'com_modules.module.213', 'Social Icons', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(298, 18, 170, 171, 2, 'com_modules.module.214', 'Footer Brand Home', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(299, 18, 172, 173, 2, 'com_modules.module.215', 'Footer Brand', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(300, 18, 174, 175, 2, 'com_modules.module.216', 'Our Services & Special Fields', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(301, 18, 176, 177, 2, 'com_modules.module.217', 'Home Caste Studies', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(302, 18, 178, 179, 2, 'com_modules.module.218', 'Home Our Work', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(303, 18, 180, 181, 2, 'com_modules.module.219', 'Home Clients Gallery', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(305, 18, 182, 183, 2, 'com_modules.module.221', 'Home Quote', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(306, 18, 184, 185, 2, 'com_modules.module.222', 'Fresh from our blog', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(307, 1, 610, 611, 1, '#__ucm_content.10', '#__ucm_content.10', '[]'),
(308, 1, 612, 613, 1, '#__ucm_content.11', '#__ucm_content.11', '[]'),
(309, 1, 614, 615, 1, '#__ucm_content.12', '#__ucm_content.12', '[]'),
(310, 190, 91, 92, 3, 'com_content.article.51', 'Avanti Theme is here', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(311, 1, 616, 617, 1, '#__ucm_content.13', '#__ucm_content.13', '[]'),
(312, 190, 93, 94, 3, 'com_content.article.52', 'Free Halloween Icons', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(313, 1, 618, 619, 1, '#__ucm_content.14', '#__ucm_content.14', '[]'),
(314, 190, 95, 96, 3, 'com_content.article.53', 'Pagekit CMS', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(315, 1, 620, 621, 1, '#__ucm_content.15', '#__ucm_content.15', '[]'),
(316, 190, 97, 98, 3, 'com_content.article.54', 'UIkit Framework', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(317, 1, 622, 623, 1, '#__ucm_content.16', '#__ucm_content.16', '[]'),
(318, 190, 99, 100, 3, 'com_content.article.55', 'Widgetkit', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(319, 1, 624, 625, 1, '#__ucm_content.17', '#__ucm_content.17', '[]'),
(320, 190, 101, 102, 3, 'com_content.article.56', 'ZOO Extension', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(321, 1, 626, 627, 1, '#__ucm_content.18', '#__ucm_content.18', '[]'),
(322, 190, 103, 104, 3, 'com_content.article.57', 'Warp Framework', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(323, 1, 628, 629, 1, '#__ucm_content.19', '#__ucm_content.19', '[]'),
(324, 190, 105, 106, 3, 'com_content.article.58', 'Beautiful Icons', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(325, 1, 630, 631, 1, '#__ucm_content.20', '#__ucm_content.20', '[]'),
(326, 190, 107, 108, 3, 'com_content.article.59', 'Joomla Templates', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(327, 1, 632, 633, 1, '#__ucm_content.21', '#__ucm_content.21', '[]'),
(328, 18, 186, 187, 2, 'com_modules.module.223', 'Portfolio Slideshow', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(329, 18, 188, 189, 2, 'com_modules.module.224', 'Portfolio Projects 1', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(330, 18, 190, 191, 2, 'com_modules.module.225', 'Portfolio Projects 2', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(331, 18, 192, 193, 2, 'com_modules.module.226', 'Portfolio Projects 3', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(332, 18, 194, 195, 2, 'com_modules.module.227', 'Portfolio Gallery', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(333, 18, 196, 197, 2, 'com_modules.module.228', 'Portfolio More Works', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(334, 18, 198, 199, 2, 'com_modules.module.229', 'Gallery', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(336, 18, 200, 201, 2, 'com_modules.module.231', 'Gallery Intro', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(337, 18, 202, 203, 2, 'com_modules.module.232', 'Gallery Our Projects', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(338, 18, 204, 205, 2, 'com_modules.module.233', 'Our Clients', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(340, 18, 206, 207, 2, 'com_modules.module.235', 'Our Special Fields', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(341, 18, 208, 209, 2, 'com_modules.module.236', 'Our Services', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(342, 18, 210, 211, 2, 'com_modules.module.237', 'Advertisment done right.', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(343, 18, 212, 213, 2, 'com_modules.module.238', 'Services Happy Clients', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(344, 18, 214, 215, 2, 'com_modules.module.239', 'Services Clients', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(345, 18, 216, 217, 2, 'com_modules.module.240', 'Services Info', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(346, 18, 218, 219, 2, 'com_modules.module.241', 'Services Testimonials', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(347, 18, 220, 221, 2, 'com_modules.module.242', 'About Our Company', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(348, 18, 222, 223, 2, 'com_modules.module.243', 'Our Office', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(349, 18, 224, 225, 2, 'com_modules.module.244', 'Company Gallery', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(350, 18, 226, 227, 2, 'com_modules.module.245', 'Do you like to join us?', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(351, 18, 228, 229, 2, 'com_modules.module.246', 'Company Jobs', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(353, 18, 230, 231, 2, 'com_modules.module.248', 'The leading chiefs', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(354, 18, 232, 233, 2, 'com_modules.module.249', 'The creative warriors', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(355, 27, 59, 60, 3, 'com_content.article.60', 'Single Page Example', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(356, 1, 634, 635, 1, '#__ucm_content.22', '#__ucm_content.22', '[]'),
(357, 18, 234, 235, 2, 'com_modules.module.250', 'Single Page Info', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(358, 18, 236, 237, 2, 'com_modules.module.251', 'Single Slideshow', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(359, 18, 238, 239, 2, 'com_modules.module.252', 'Single Page More Projects Headline', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(360, 18, 240, 241, 2, 'com_modules.module.253', 'Single Page More Projects Widget', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(361, 18, 242, 243, 2, 'com_modules.module.254', 'Bottom A', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(362, 18, 244, 245, 2, 'com_modules.module.255', 'Bottom D', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(363, 18, 246, 247, 2, 'com_modules.module.256', 'Bottom D', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(364, 18, 248, 249, 2, 'com_modules.module.257', 'Top D', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(365, 18, 250, 251, 2, 'com_modules.module.258', 'Top D', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(366, 18, 252, 253, 2, 'com_modules.module.259', 'Top D', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(367, 18, 254, 255, 2, 'com_modules.module.260', 'Top D', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(368, 18, 256, 257, 2, 'com_modules.module.261', 'Theme Styles Grid', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(369, 18, 258, 259, 2, 'com_modules.module.262', 'Theme Widgets Headline', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(370, 18, 260, 261, 2, 'com_modules.module.263', 'Theme Widgets', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(371, 18, 262, 263, 2, 'com_modules.module.264', 'Theme Additions Headline', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(372, 18, 264, 265, 2, 'com_modules.module.265', 'Theme Additions', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(373, 18, 266, 267, 2, 'com_modules.module.266', 'Theme Icons', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}');

-- --------------------------------------------------------
DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE `#__categories` (
`id` int(11) NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `extension` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned DEFAULT NULL,
  `params` text NOT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1'
)  AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

--
-- Daten für Tabelle `#__categories`
--

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES
(1, 0, 0, 0, 21, 0, '', 'system', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '', 322, '2009-10-18 16:07:09', 0, '0000-00-00 00:00:00', 0, '*', 1),
(2, 27, 1, 1, 2, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 322, '2010-06-28 13:26:37', 0, '0000-00-00 00:00:00', 5, '*', 1),
(3, 28, 1, 3, 4, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":"","foobar":""}', '', '', '{"page_title":"","author":"","robots":""}', 322, '2010-06-28 13:27:35', 0, '0000-00-00 00:00:00', 0, '*', 1),
(4, 29, 1, 5, 6, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 322, '2010-06-28 13:27:57', 0, '0000-00-00 00:00:00', 0, '*', 1),
(5, 30, 1, 7, 8, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 322, '2010-06-28 13:28:15', 0, '0000-00-00 00:00:00', 0, '*', 1),
(7, 32, 1, 11, 12, 1, 'blog', 'com_content', 'Blog', 'blog', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 322, '2011-05-02 11:42:21', 322, '2015-04-30 09:05:07', 170, '*', 1),
(8, 56, 1, 13, 14, 1, 'contacts', 'com_contact', 'Contacts', 'contacts', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 322, '2011-11-18 16:32:10', 42, '2011-11-18 16:32:13', 0, '*', 1),
(10, 190, 1, 17, 18, 1, 'blog-dynamic', 'com_content', 'Blog Dynamic', 'blog-dynamic', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 322, '2015-04-14 14:43:15', 322, '2015-04-26 18:48:04', 0, '*', 1),
(11, 211, 1, 19, 20, 1, 'blog-alternate', 'com_content', 'Blog Alternate', 'blog-alternate', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 322, '2015-04-24 10:21:41', 0, '2015-04-24 10:21:41', 0, '*', 1);

-- --------------------------------------------------------
DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE `#__contact_details` (
`id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `con_position` varchar(255) DEFAULT NULL,
  `address` text,
  `suburb` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `postcode` varchar(100) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `misc` mediumtext,
  `image` varchar(255) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned DEFAULT NULL,
  `mobile` varchar(255) NOT NULL DEFAULT '',
  `webpage` varchar(255) NOT NULL DEFAULT '',
  `sortname1` varchar(255) NOT NULL,
  `sortname2` varchar(255) NOT NULL,
  `sortname3` varchar(255) NOT NULL,
  `language` char(7) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0'
)  AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Daten für Tabelle `#__contact_details`
--

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`, `version`, `hits`) VALUES
(1, 'John Q. Public', 'john-q-public', 'Chief Information Officer', '1 Infinite Loop', 'Cupertino', 'California', 'USA', '95014', '1-212-555555-1', '1-212-555555-2', 'Lorem ipsum dolor sit amet, consetetur sadipscing elitr.', '', 'email@0.0.0.0', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","contact_layout":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 8, 1, '', '', '', '', '', '*', '2011-11-18 16:33:47', 322, '', '2012-01-23 15:36:01', 42, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(2, 'Jane Q. Public', 'jane-q-public', 'Chief Information Officer', '1 Infinite Loop', 'Cupertino', 'California', 'USA', '95014', '1-212-555555-1', '1-212-555555-2', 'Lorem ipsum dolor sit amet, consetetur sadipscing elitr.', '', 'email@0.0.0.0', 0, 1, 0, '0000-00-00 00:00:00', 2, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","contact_layout":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 8, 1, '', '', '', '', '', '*', '2011-11-18 16:35:05', 322, '', '2012-01-19 16:37:23', 42, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0);

-- --------------------------------------------------------
DROP TABLE IF EXISTS `#__content`;
CREATE TABLE `#__content` (
`id` int(10) unsigned NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `attribs` varchar(5120) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.'
)  AUTO_INCREMENT=61 DEFAULT CHARSET=utf8;

--
-- Daten für Tabelle `#__content`
--

INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(1, 33, 'Layouts', 'layouts', '<p>Warp comes with a sophisticated layout system to create any kind of sidebar or widget layout. You can easily manage the sidebar''s positions and widths in the theme administration. Widgets can have different styles and be placed in any position offered by this theme. Each position has its own layout. You can align widgets side-by-side, stack them or choose your own grid layout. Show or hide widgets on mobile devices, while the grid adapts perfectly to your layout.</p>\n\n<img src="images/yootheme/features_layouts.svg" width="560" height="410" alt="Warp Layout System" title="Warp Layout System" />', '', 1, 2, '2011-05-02 11:45:23', 322, '', '2015-07-21 15:02:32', 322, 0, '0000-00-00 00:00:00', '2011-05-02 11:45:23', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 14, 8, '', '', 1, 1258, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(4, 36, 'UIkit', 'uikit', '        <div class="uk-grid">\n            <div class="uk-width-1-1" data-uk-margin>\n\n                <div class="uk-button-group">\n                    <button class="uk-button">Button</button>\n                    <div data-uk-dropdown="{mode:''click''}">\n                        <button class="uk-button"><i class="uk-icon-caret-down"></i></button>\n                        <div class="uk-dropdown uk-dropdown-width-2">\n\n                            <div class="uk-grid uk-dropdown-grid">\n\n                                <div class="uk-width-1-2">\n                                    <ul class="uk-nav uk-nav-dropdown uk-panel">\n                                        <li class="uk-nav-header">Header</li>\n                                        <li><a href="#">Item</a></li>\n                                        <li><a href="#">Item</a></li>\n                                        <li class="uk-nav-divider"></li>\n                                        <li><a href="#">Separated item</a></li>\n                                        <li class="uk-parent">\n                                            <a href="#">Parent</a>\n                                            <ul class="uk-nav-sub">\n                                                <li><a href="#">Sub item</a>\n                                                    <ul>\n                                                        <li><a href="#">Sub item</a></li>\n                                                    </ul>\n                                                </li>\n                                            </ul>\n                                        </li>\n                                    </ul>\n                                </div>\n\n                                <div class="uk-width-1-2">\n                                    <ul class="uk-nav uk-nav-dropdown uk-panel">\n                                        <li class="uk-nav-header">Header</li>\n                                        <li><a href="#">Item</a></li>\n                                        <li><a href="#">Item</a></li>\n                                        <li class="uk-nav-divider"></li>\n                                        <li><a href="#">Separated item</a></li>\n                                        <li class="uk-parent">\n                                            <a href="#">Parent</a>\n                                            <ul class="uk-nav-sub">\n                                                <li><a href="#">Sub item</a>\n                                                    <ul>\n                                                        <li><a href="#">Sub item</a></li>\n                                                    </ul>\n                                                </li>\n                                            </ul>\n                                        </li>\n                                    </ul>\n                                </div>\n\n                            </div>\n\n                        </div>\n                    </div>\n                </div>\n\n                <div class="uk-button-group">\n                    <button class="uk-button uk-button-primary">Primary</button>\n                    <div data-uk-dropdown="{mode:''click''}">\n                        <button class="uk-button uk-button-primary"><i class="uk-icon-caret-down"></i></button>\n                        <div class="uk-dropdown uk-dropdown-small">\n                            <ul class="uk-nav uk-nav-dropdown">\n                                <li class="uk-nav-header">Header</li>\n                                <li><a href="#">Item</a></li>\n                                <li><a href="#">Item</a></li>\n                                <li class="uk-nav-divider"></li>\n                                <li><a href="#">Separated item</a></li>\n                                <li class="uk-parent">\n                                    <a href="#">Parent</a>\n                                    <ul class="uk-nav-sub">\n                                        <li><a href="#">Sub item</a>\n                                            <ul>\n                                                <li><a href="#">Sub item</a></li>\n                                            </ul>\n                                        </li>\n                                    </ul>\n                                </li>\n                            </ul>\n                        </div>\n                    </div>\n                </div>\n\n                <div class="uk-button-group">\n                    <button class="uk-button uk-button-success">Success</button>\n                    <div data-uk-dropdown="{mode:''click''}">\n                        <button class="uk-button uk-button-success"><i class="uk-icon-caret-down"></i></button>\n                        <div class="uk-dropdown">\n                            <ul class="uk-nav uk-nav-dropdown">\n                                <li class="uk-nav-header">Header</li>\n                                <li><a href="#">Item</a></li>\n                                <li><a href="#">Item</a></li>\n                                <li class="uk-nav-divider"></li>\n                                <li><a href="#">Separated item</a></li>\n                                <li class="uk-parent">\n                                    <a href="#">Parent</a>\n                                    <ul class="uk-nav-sub">\n                                        <li><a href="#">Sub item</a>\n                                            <ul>\n                                                <li><a href="#">Sub item</a></li>\n                                            </ul>\n                                        </li>\n                                    </ul>\n                                </li>\n                            </ul>\n                        </div>\n                    </div>\n                </div>\n\n                <div class="uk-button-group">\n                    <button class="uk-button uk-button-danger">Danger</button>\n                    <div data-uk-dropdown="{mode:''click''}">\n                        <button class="uk-button uk-button-danger"><i class="uk-icon-caret-down"></i></button>\n                        <div class="uk-dropdown">\n                            <ul class="uk-nav uk-nav-dropdown">\n                                <li class="uk-nav-header">Header</li>\n                                <li><a href="#">Item</a></li>\n                                <li><a href="#">Item</a></li>\n                                <li class="uk-nav-divider"></li>\n                                <li><a href="#">Separated item</a></li>\n                                <li class="uk-parent">\n                                    <a href="#">Parent</a>\n                                    <ul class="uk-nav-sub">\n                                        <li><a href="#">Sub item</a>\n                                            <ul>\n                                                <li><a href="#">Sub item</a></li>\n                                            </ul>\n                                        </li>\n                                    </ul>\n                                </li>\n                            </ul>\n                        </div>\n                    </div>\n                </div>\n\n                <button class="uk-button" disabled>Disabled</button>\n                <button class="uk-button" data-uk-tooltip title="Bazinga!">Tooltip</button>\n                <button class="uk-button" data-uk-modal="{target:''#modal-1''}">Modal</button>\n                <button class="uk-button" data-uk-offcanvas="{target:''#offcanvas-1''}">Off-canvas</button>\n                <button class="uk-button uk-button-link">Button link</button>\n\n            </div>\n        </div>\n\n        <hr class="uk-grid-divider">\n\n        <div class="uk-grid" data-uk-grid-margin>\n\n            <div class="uk-width-medium-1-2">\n\n                <div class="uk-grid" data-uk-grid-margin>\n\n                    <div class="uk-width-1-1">\n                        <ul class="uk-breadcrumb">\n                            <li><a href="#">Home</a></li>\n                            <li><a href="#">Blog</a></li>\n                            <li><span>Category</span></li>\n                            <li class="uk-active"><span>Post</span></li>\n                        </ul>\n                    </div>\n\n                    <div class="uk-width-1-1">\n\n                        <article class="uk-article">\n\n                            <h1 class="uk-article-title">Article title</h1>\n\n                            <p class="uk-article-meta">Written by Super User on 12 April. Posted in Blog</p>\n\n                            <div class="uk-grid" data-uk-grid-margin>\n                                <div class="uk-width-1-1 uk-margin-small-bottom">\n                                    <figure class="uk-overlay uk-overlay-hover">\n                                        <img class="uk-overlay-scale" src="images/yootheme/uikit.jpg" width="1080" height="540" alt="UIkit">\n                                        <div class="uk-overlay-panel uk-overlay-icon uk-overlay-background uk-overlay-fade"></div>\n                                    </figure>\n                                </div>\n                            </div>\n\n                            <p class="uk-article-lead">Lorem ipsum dolor sit amet.</p>\n                            <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\n                            <pre><code>&lt;div class="myclass"&gt;...&lt;/div&gt;</code></pre>\n                            <hr class="uk-article-divider">\n                            <div class="uk-grid" data-uk-grid-margin>\n\n                                <div class="uk-width-medium-1-5">\n                                    <span class="uk-text-muted">text-muted</span><br>\n                                    <span class="uk-text-primary">text-primary</span><br>\n                                    <span class="uk-text-success">text-success</span><br>\n                                    <span class="uk-text-warning">text-warning</span><br>\n                                    <span class="uk-text-danger">text-danger</span>\n                                </div>\n\n                                <div class="uk-width-medium-3-10">\n                                    <a href="#">a element</a><br>\n                                    <em>em element</em><br>\n                                    <strong>strong</strong><br>\n                                    <code>code element</code><br>\n                                    <del>del element</del>\n                                </div>\n\n                                <div class="uk-width-medium-2-5">\n                                    <ins>ins element</ins><br>\n                                    <mark>mark element</mark><br>\n                                    <q>q <q>inside</q> a q element </q><br>\n                                    <abbr title="Abbreviation Element">abbr element</abbr><br>\n                                    <dfn title="Defines a definition term">dfn element</dfn>\n                                </div>\n\n                                <div class="uk-width-1-1">\n                                    <p class="uk-text-center">\n                                        <span class="uk-badge">Badge</span>\n                                        <span class="uk-badge uk-badge-notification">1</span>\n                                        <span class="uk-badge uk-badge-success">Success</span>\n                                        <span class="uk-badge uk-badge-success uk-badge-notification">4</span>\n                                        <span class="uk-badge uk-badge-warning">Warning</span>\n                                        <span class="uk-badge uk-badge-warning uk-badge-notification">3</span>\n                                        <span class="uk-badge uk-badge-danger">Danger</span>\n                                        <span class="uk-badge uk-badge-danger uk-badge-notification">4</span>\n                                    </p>\n                                </div>\n\n                                <div class="uk-width-medium-1-2">\n                                    <h1 class="uk-display-inline">h1</h1>\n                                    <h2 class="uk-display-inline">h2</h2>\n                                    <h3 class="uk-display-inline">h3</h3>\n                                    <h4 class="uk-display-inline">h4</h4>\n                                    <h5 class="uk-display-inline">h5</h5>\n                                    <h6 class="uk-display-inline">h6</h6>\n                                </div>\n\n                                <div class="uk-width-medium-1-2">\n                                    <blockquote>\n                                        <p> Lorem ipsum dolor.</p>\n                                        <small>Someone famous</small>\n                                    </blockquote>\n                                </div>\n\n                            </div>\n\n                        </article>\n\n                    </div>\n\n                    <div class="uk-width-1-1">\n                        <ul class="uk-comment-list">\n                            <li>\n                                <article class="uk-comment">\n                                    <header class="uk-comment-header">\n                                        <img class="uk-comment-avatar" src="images/yootheme/uikit_avatar.svg" width="50" height="50" alt="">\n                                        <h4 class="uk-comment-title">Author</h4>\n                                        <p class="uk-comment-meta">May 2, 2090 at 1:55 pm</p>\n                                    </header>\n                                    <div class="uk-comment-body">\n                                        <p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna.</p>\n                                    </div>\n                                </article>\n                            </li>\n                        </ul>\n                    </div>\n\n                    <div class="uk-width-1-1">\n                        <ul class="uk-pagination">\n                            <li class="uk-disabled"><span><i class="uk-icon-angle-double-left"></i></span></li>\n                            <li class="uk-active"><span>1</span></li>\n                            <li><a href="#">2</a></li>\n                            <li><a href="#">3</a></li>\n                            <li><a href="#">4</a></li>\n                            <li><span>...</span></li>\n                            <li><a href="#">20</a></li>\n                            <li><a href="#"><i class="uk-icon-angle-double-right"></i></a></li>\n                        </ul>\n                    </div>\n\n                </div>\n\n            </div>\n\n            <div class="uk-width-medium-1-2">\n\n                <div class="uk-grid" data-uk-grid-margin>\n\n                    <div class="uk-width-medium-1-2">\n\n                        <div class="uk-panel">\n                            <ul class="uk-nav uk-nav-side uk-nav-parent-icon" data-uk-nav>\n                                <li class="uk-nav-header">Header</li>\n                                <li class="uk-nav-divider"></li>\n                                <li class="uk-active"><a href="#">Active</a></li>\n                                <li class="uk-parent">\n                                    <a href="#">Parent</a>\n                                    <ul class="uk-nav-sub">\n                                        <li><a href="#">Sub item</a></li>\n                                        <li><a href="#">Sub item</a>\n                                            <ul>\n                                                <li><a href="#">Sub item</a></li>\n                                                <li><a href="#">Sub item</a></li>\n                                            </ul>\n                                        </li>\n                                    </ul>\n                                </li>\n                                <li><a href="#">Item</a></li>\n                            </ul>\n                        </div>\n\n                        <div class="uk-panel uk-panel-divider">\n                            <h3 class="uk-panel-title">Divider</h3>\n                            Lorem ipsum <a href="#">dolor</a> sit amet, consectetur adipisicing elit.\n                        </div>\n\n                        <div class="uk-panel uk-panel-header">\n                            <h3 class="uk-panel-title">Header</h3>\n                            Lorem ipsum <a href="#">dolor</a> sit amet, consectetur adipisicing elit.\n                        </div>\n\n                    </div>\n\n                    <div class="uk-width-medium-1-2">\n\n                        <div class="uk-panel uk-panel-box">\n                            <h3 class="uk-panel-title">Box</h3>\n                            Lorem ipsum <a href="#">dolor</a> sit amet, consectetur adipisicing elit.\n                        </div>\n\n                        <div class="uk-panel uk-panel-box uk-panel-box-primary">\n                            <h3 class="uk-panel-title">Box primary</h3>\n                            Lorem ipsum <a href="#">dolor</a> sit amet, consectetur adipisicing elit.\n                        </div>\n\n                        <div class="uk-panel uk-panel-box uk-panel-box-secondary">\n                            <h3 class="uk-panel-title">Box secondary</h3>\n                            Lorem ipsum <a href="#">dolor</a> sit amet, consectetur adipisicing elit.\n                        </div>\n\n                    </div>\n\n                </div>\n\n                <div class="uk-grid" data-uk-grid-margin>\n\n                    <div class="uk-width-1-2">\n                        <div class="uk-alert" data-uk-alert>\n                            <a class="uk-alert-close uk-close"></a>\n                            <p>Info message</p>\n                        </div>\n                    </div>\n\n                    <div class="uk-width-1-2">\n                        <div class="uk-alert uk-alert-success" data-uk-alert>\n                            <a class="uk-alert-close uk-close"></a>\n                            <p>Success message</p>\n                        </div>\n                    </div>\n\n                    <div class="uk-width-1-2">\n                        <div class="uk-alert uk-alert-warning" data-uk-alert>\n                            <a class="uk-alert-close uk-close"></a>\n                            <p>Warning message</p>\n                        </div>\n                    </div>\n\n                    <div class="uk-width-1-2">\n                        <div class="uk-alert uk-alert-danger" data-uk-alert>\n                            <a class="uk-alert-close uk-close"></a>\n                            <p>Danger message</p>\n                        </div>\n                    </div>\n\n                    <div class="uk-width-1-2">\n                        <div class="uk-progress">\n                            <div class="uk-progress-bar" style="width: 55%;">55%</div>\n                        </div>\n                    </div>\n\n                    <div class="uk-width-1-2">\n                        <div class="uk-progress uk-progress-success">\n                            <div class="uk-progress-bar" style="width: 55%;">55%</div>\n                        </div>\n                    </div>\n\n                    <div class="uk-width-1-2">\n                        <div class="uk-progress uk-progress-warning">\n                            <div class="uk-progress-bar" style="width: 55%;">55%</div>\n                        </div>\n                    </div>\n\n                    <div class="uk-width-1-2">\n                        <div class="uk-progress uk-progress-danger">\n                            <div class="uk-progress-bar" style="width: 55%;">55%</div>\n                        </div>\n                    </div>\n\n                    <div class="uk-width-1-2 uk-form">\n                        <fieldset>\n                            <legend>Form states</legend>\n                            <div class="uk-form-row">\n                                <input type="text" placeholder="Text Input" class="uk-width-1-1">\n                            </div>\n                            <div class="uk-form-row">\n                                <input type="text" placeholder="form-success" value="form-success" class="uk-width-1-1 uk-form-success">\n                            </div>\n                            <div class="uk-form-row">\n                                <input type="text" placeholder="form-danger" value="form-danger" class="uk-width-1-1 uk-form-danger">\n                            </div>\n                            <div class="uk-form-row">\n                                <input type="text" placeholder="form disabled" class="uk-width-1-1" disabled>\n                            </div>\n                        </fieldset>\n                    </div>\n\n                    <div class="uk-width-1-2 uk-form">\n                        <fieldset>\n                            <legend>Form styles</legend>\n                            <div class="uk-form-row">\n                                <input type="text" placeholder="form-large" class="uk-form-large uk-form-width-small">\n                                <button class="uk-button uk-button-large" type="reset">Large</button>\n                            </div>\n                            <div class="uk-form-row">\n                                <input type="text" placeholder="form-small" class="uk-form-small uk-form-width-small">\n                                <button class="uk-button uk-button-small" type="reset">Small</button>\n                            </div>\n                            <div class="uk-form-row">\n                                <input type="text" placeholder="form-blank" class="uk-form-width-small uk-form-blank">\n                                <button class="uk-button uk-button-mini" type="reset">Mini</button>\n                            </div>\n                        </fieldset>\n                    </div>\n\n                </div>\n\n            </div>\n\n        </div>\n\n        <hr class="uk-grid-divider">\n\n        <div class="uk-grid" data-uk-grid-margin>\n\n            <div class="uk-width-medium-1-4">\n\n                <ul class="uk-subnav uk-subnav-line">\n                    <li class="uk-active"><a href="#">Active</a></li>\n                    <li><a href="#">Item</a></li>\n                    <li class="uk-disabled"><a href="#">Disabled</a></li>\n                </ul>\n\n            </div>\n            <div class="uk-width-medium-1-4">\n\n                <ul class="uk-subnav uk-subnav-pill">\n                    <li class="uk-active"><a href="#">Active</a></li>\n                    <li><a href="#">Item</a></li>\n                    <li class="uk-disabled"><a href="#">Disabled</a></li>\n                </ul>\n\n            </div>\n            <div class="uk-width-medium-1-4">\n\n                <ul class="uk-tab" data-uk-tab>\n                    <li class="uk-active"><a href="#">Active</a></li>\n                    <li><a href="#">Item</a></li>\n                    <li class="uk-disabled"><a href="#">Disabled</a></li>\n                </ul>\n\n            </div>\n            <div class="uk-width-medium-1-4">\n\n                <a href="#" class="uk-icon-button uk-icon-github"></a>\n                <a href="#" class="uk-icon-button uk-icon-twitter"></a>\n                <a href="#" class="uk-icon-button uk-icon-dribbble"></a>\n                <a href="#" class="uk-icon-button uk-icon-html5"></a>\n\n            </div>\n        </div>\n\n        <hr class="uk-grid-divider">\n\n        <div class="uk-grid uk-grid-divider" data-uk-grid-margin>\n            <div class="uk-width-medium-1-4">\n\n                <ul class="uk-list uk-list-line">\n                    <li>List item 1</li>\n                    <li>List item 2</li>\n                    <li>List item 3</li>\n                </ul>\n\n            </div>\n\n            <div class="uk-width-medium-1-4">\n\n                <ul class="uk-list uk-list-striped">\n                    <li>List item 1</li>\n                    <li>List item 2</li>\n                    <li>List item 3</li>\n                </ul>\n\n            </div>\n            <div class="uk-width-medium-1-4">\n\n                <table class="uk-table uk-table-striped uk-table-condensed uk-table-hover">\n                    <caption>Table caption</caption>\n                    <thead>\n                        <tr>\n                            <th>Table</th>\n                            <th>Heading</th>\n                        </tr>\n                    </thead>\n                    <tbody>\n                        <tr>\n                            <td>Table</td>\n                            <td>Data</td>\n                        </tr>\n                        <tr>\n                            <td>Table</td>\n                            <td>Data</td>\n                        </tr>\n                    </tbody>\n                </table>\n\n            </div>\n            <div class="uk-width-medium-1-4">\n\n                <dl class="uk-description-list uk-description-list-line">\n                    <dt>Description lists</dt>\n                    <dd>Description text.</dd>\n                    <dt>Description lists</dt>\n                    <dd>Description text.</dd>\n                </dl>\n\n            </div>\n        </div>\n\n        <div id="offcanvas-1" class="uk-offcanvas">\n            <div class="uk-offcanvas-bar">\n\n                <ul class="uk-nav uk-nav-offcanvas uk-nav-parent-icon" data-uk-nav>\n                    <li><a href="#">Item</a></li>\n                    <li class="uk-active"><a href="#">Active</a></li>\n\n                    <li class="uk-parent">\n                        <a href="#">Parent</a>\n                        <ul class="uk-nav-sub">\n                            <li><a href="#">Sub item</a></li>\n                            <li><a href="#">Sub item</a>\n                                <ul>\n                                    <li><a href="#">Sub item</a></li>\n                                    <li><a href="#">Sub item</a></li>\n                                </ul>\n                            </li>\n                        </ul>\n                    </li>\n\n                    <li class="uk-parent">\n                        <a href="#">Parent</a>\n                        <ul class="uk-nav-sub">\n                            <li><a href="#">Sub item</a></li>\n                            <li><a href="#">Sub item</a></li>\n                        </ul>\n                    </li>\n\n                    <li><a href="#">Item</a></li>\n\n                    <li class="uk-nav-header">Header</li>\n                    <li><a href="#"><i class="uk-icon-star"></i> Item</a></li>\n                    <li><a href="#"><i class="uk-icon-twitter"></i> Item</a></li>\n                    <li class="uk-nav-divider"></li>\n                    <li><a href="#"><i class="uk-icon-rss"></i> Item</a></li>\n                </ul>\n\n                <div class="uk-panel">\n                    <h3 class="uk-panel-title">Title</h3>\n                    Lorem ipsum dolor sit amet, <a href="#">consetetur</a> sadipscing elitr.\n                </div>\n\n                <div class="uk-panel">\n                    <h3 class="uk-panel-title">Title</h3>\n                    Lorem ipsum dolor sit amet, <a href="#">consetetur</a> sadipscing elitr.\n                </div>\n\n            </div>\n        </div>\n\n        <div id="modal-1" class="uk-modal">\n            <div class="uk-modal-dialog">\n                <button type="button" class="uk-modal-close uk-close"></button>\n                <h1>Headline</h1>\n                <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\n            </div>\n        </div>', '', 1, 2, '2011-05-02 11:47:45', 322, '', '2015-05-05 13:17:43', 322, 0, '0000-00-00 00:00:00', '2011-05-02 11:47:45', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 34, 9, '', '', 1, 644, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(5, 37, 'Dummy Content', 'dummy-content', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.', '', 1, 2, '2011-05-02 11:48:08', 322, '', '2011-05-02 13:45:48', 42, 0, '0000-00-00 00:00:00', '2011-05-02 11:48:08', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":""}', 2, 10, '', '', 1, 41, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(6, 38, 'Theme', 'theme', '<h1 class="uk-article-title uk-text-center">Theme Features</h1>\n<p class="uk-text-large uk-text-center">Avanti is featuring brand new and advanced Warp options.</p>\n\n[widgetkit id="56" name="Theme Features"]', '', 1, 2, '2011-05-02 11:48:41', 322, '', '2015-12-14 16:28:27', 322, 0, '0000-00-00 00:00:00', '2011-05-02 11:48:41', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 95, 11, '', '', 1, 1432, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(7, 39, 'Home', 'home', 'This is a hidden article.', '', 1, 2, '2011-05-02 11:49:24', 322, '', '2015-04-26 18:57:52', 322, 0, '0000-00-00 00:00:00', '2011-05-02 11:49:24', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 14, 12, '', '', 1, 13393, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(8, 40, 'Joomla Templates', 'joomla-templates', '<p class="uk-text-large">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p class="uk-column-large-1-2">\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n', '\n\n<p class="uk-column-large-1-2">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<br /><br /> \n\nLorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p> \n\n<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p class="uk-column-large-1-2">Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 7, '2014-04-02 11:50:02', 322, '', '2015-12-07 16:57:12', 322, 0, '0000-00-00 00:00:00', '2014-04-02 11:50:02', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-02.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-02.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 86, 1, '', '', 1, 175, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(9, 41, 'Beautiful Icons', 'beautiful-icons', '<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p>\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n', '\n\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<br /><br /> \n\nLorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p> \n\n<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 7, '2014-03-15 11:50:30', 322, '', '2015-12-07 16:50:02', 322, 0, '0000-00-00 00:00:00', '2014-03-15 11:50:30', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-08.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-08.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 31, 4, '', '', 1, 27, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(10, 42, 'Warp Framework', 'warp-framework', '<p class="uk-text-large">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p class="uk-column-large-1-2">\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n', '\n\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<br /><br /> \n\nLorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p> \n\n<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 7, '2014-03-12 11:50:55', 322, '', '2015-12-07 16:52:25', 322, 0, '0000-00-00 00:00:00', '2014-03-12 11:50:55', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-07.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-07.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 36, 5, '', '', 1, 27, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(11, 43, 'ZOO Extension', 'zoo-extension', '<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', '\n\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<br /><br /> \n\nLorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p>\n\n<p>\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n<p>Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 7, '2014-02-28 11:51:30', 322, '', '2015-12-07 16:51:14', 322, 0, '0000-00-00 00:00:00', '2014-02-28 11:51:30', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-06.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-06.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 29, 6, '', '', 1, 12, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(13, 159, 'Widgetkit', 'widgetkit', '<div class="uk-margin-large-bottom uk-text-center">\n    <h2 class="uk-h1 uk-margin-bottom-remove">Widgets</h2>\n    <p class="uk-text-large uk-margin-small-top">Currently available widgets</p>\n</div>\n\n[widgetkit id="26" name="Widgetkit 2 Widgets"]\n\n<hr class="uk-article-divider uk-margin-large">\n\n<div class="uk-margin-large-bottom uk-text-center">\n    <h2 class="uk-h1 uk-margin-bottom-remove">Theme Widgets</h2>\n    <p class="uk-text-large uk-margin-small-top">Custom widgets for the Avanti theme</p>\n</div>\n\n[widgetkit id="115" name="Widgetkit Theme Widgets"]\n\n\n<hr class="uk-article-divider uk-margin-large">\n\n<div class="uk-margin-large uk-text-center">\n    <h2 class="uk-h1 uk-margin-bottom-remove">How to use</h2>\n    <p class="uk-text-large uk-margin-small-top">Use a shortcode to display your widget anywhere on your website</p>\n</div>\n\n[widgetkit id="28" name="Widgetkit 2 Tutorial"]\n\n<hr class="uk-article-divider uk-margin-large">\n\n<div class="uk-margin-large uk-text-center">\n    <h2 class="uk-h1 uk-margin-bottom-remove">Features</h2>\n    <p class="uk-text-large uk-margin-small-top">All widgets make use of modern web technologies</p>\n</div>\n\n[widgetkit id="25" name="Widgetkit 2 Features"]', '', 1, 2, '2011-06-08 11:15:54', 322, '', '2015-12-14 12:36:06', 322, 0, '0000-00-00 00:00:00', '2011-06-08 11:15:54', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 49, 7, '', '', 1, 377, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(23, 206, 'Widgetkit', 'widgetkit-extension', '<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p>\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n', '\n\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<br /><br /> \n\nLorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p> \n\n<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 7, '2014-02-14 11:50:55', 322, '', '2015-12-07 16:51:40', 322, 0, '0000-00-00 00:00:00', '2014-02-14 11:50:55', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-05.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-05.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 31, 7, '', '', 1, 10, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(24, 151, 'UIkit Framework', 'uikit', '<p class="uk-column-xlarge-1-4 uk-column-large-1-3 uk-column-medium-1-2">\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n', '\n\n<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p class="uk-column-xlarge-1-4 uk-column-large-1-3 uk-column-medium-1-2">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<br /><br /> \n\nLorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p> \n\n<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p class="uk-column-xlarge-1-4 uk-column-large-1-3 uk-column-medium-1-2">Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 7, '2014-03-22 11:50:55', 322, '', '2015-12-07 16:56:57', 322, 0, '0000-00-00 00:00:00', '2014-03-22 11:50:55', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-04.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-04.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 40, 3, '', '', 1, 13, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(25, 153, 'Pagekit CMS', 'pagekit', '<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', '\n\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<br /><br /> \n\nLorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p>\n\n<p>\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n<p>Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 7, '2014-03-28 15:50:55', 322, '', '2015-12-07 16:51:00', 322, 0, '0000-00-00 00:00:00', '2014-03-28 15:50:55', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-03.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-03.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 40, 2, '', '', 1, 17, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(26, 156, 'Free Halloween Icons', 'free-halloween-icons', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', '\n\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<br /><br /> \n\nLorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p> \n\n<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 7, '2014-01-18 14:50:55', 322, '', '2015-12-07 16:50:54', 322, 0, '0000-00-00 00:00:00', '2014-01-18 14:50:55', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-09.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-09.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 39, 8, '', '', 1, 13, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(28, 165, 'Gallery', 'gallery', 'Hidden article.', '', 1, 2, '2015-04-02 09:06:10', 322, '', '2015-07-20 13:45:45', 322, 0, '0000-00-00 00:00:00', '2015-04-02 09:06:10', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 6, '', '', 1, 331, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(41, 200, 'Blog Dynamic', 'blog', '[widgetkit id="54" name="Blog Grid Dynamic"]', '', 1, 2, '2015-04-15 15:12:29', 322, '', '2015-07-24 16:01:28', 322, 0, '0000-00-00 00:00:00', '2015-04-15 15:12:29', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"right","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 17, 5, '', '', 1, 967, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(46, 247, 'Portfolio', 'portfolio', 'Hidden article.', '', 1, 2, '2015-05-27 07:40:45', 322, '', '2015-11-25 09:20:06', 322, 0, '0000-00-00 00:00:00', '2015-05-27 07:40:45', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 4, '', '', 1, 494, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(47, 248, 'Services', 'services', 'Hidden article.', '', 1, 2, '2015-05-27 07:40:54', 322, '', '2015-11-25 09:19:10', 322, 0, '0000-00-00 00:00:00', '2015-05-27 07:40:54', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 3, '', '', 1, 354, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(48, 249, 'Get in touch', 'company', '<form class="uk-form">\n    <div class="uk-grid uk-grid-width-medium-1-2" data-uk-grid-margin>\n        <div>\n            <label class="uk-form-label uk-visible-small" for="tm-form-fname">First Name</label>\n            <input type="text" placeholder="John" class="uk-width-1-1" id="tm-form-fname">\n        </div>\n        <div>\n            <label class="uk-form-label uk-visible-small" for="tm-form-lname">Last Name</label>\n            <input type="text" placeholder="Doe" class="uk-width-1-1" id="tm-form-lname">\n        </div>\n        <div>\n            <label class="uk-form-label uk-visible-small" for="tm-form-phone">Phone</label>\n            <input type="tel" placeholder="+49 555 345 928" class="uk-width-1-1" id="tm-form-phone">\n        </div>\n        <div>\n            <label class="uk-form-label uk-visible-small" for="tm-form-email">Email</label>\n            <input type="email" placeholder="yoo@domain" class="uk-width-1-1" id="tm-form-email">\n        </div>\n    </div>\n    <div class="uk-grid uk-grid-width-1-1" data-uk-grid-margin>\n        <div>\n            <label class="uk-form-label uk-visible-small" for="tm-form-message">Message</label>\n            <textarea cols="100" rows="5" placeholder="Your message" class="uk-width-1-1" id="tm-form-message"></textarea>\n        </div>\n        <div>\n            <button class="uk-button uk-button-large uk-button-primary">Send Message</button>\n        </div>\n    </div>\n</form>', '', 1, 2, '2015-05-27 07:41:06', 322, '', '2015-12-09 16:17:57', 322, 0, '0000-00-00 00:00:00', '2015-05-27 07:41:06', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 22, 2, '', '', 1, 396, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(49, 271, 'Avanti Theme is here', 'avanti-theme', '<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p>\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n', '\n\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<br /><br /> \n\nLorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p> \n\n<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 7, '2014-04-18 14:50:55', 322, '', '2015-12-07 16:51:34', 322, 0, '0000-00-00 00:00:00', '2014-04-18 14:50:55', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-01.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-01.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 22, 0, '', '', 1, 45, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(50, 295, 'Search', 'search', '', '', 1, 2, '2015-07-29 13:20:13', 322, '', '2015-07-29 13:20:13', 0, 0, '0000-00-00 00:00:00', '2015-07-29 13:20:13', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(51, 310, 'Avanti Theme is here', 'avanti-theme-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', '\n\n<p class="uk-column-medium-1-2">\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p class="uk-text-large">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\n\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p> \n\n<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 10, '2014-04-18 14:50:55', 322, '', '2015-12-14 14:37:33', 322, 0, '0000-00-00 00:00:00', '2014-04-18 14:50:55', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-dynamic-01.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-dynamic-01.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 25, 0, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(52, 312, 'Free Halloween Icons', 'free-halloween-icons-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', '\n\n<p class="uk-column-medium-1-2">\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p class="uk-text-large">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\n\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p> \n\n<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 10, '2014-01-18 14:50:55', 322, '', '2015-12-14 14:37:39', 322, 0, '0000-00-00 00:00:00', '2014-01-18 14:50:55', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-dynamic-09.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-dynamic-09.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 42, 8, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(53, 314, 'Pagekit CMS', 'pagekit-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', '\n\n<p class="uk-column-medium-1-2">\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p class="uk-text-large">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\n\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p> \n\n<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 10, '2014-03-28 15:50:55', 322, '', '2015-12-14 14:37:46', 322, 0, '0000-00-00 00:00:00', '2014-03-28 15:50:55', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-dynamic-03.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-dynamic-03.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 43, 2, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(54, 316, 'UIkit Framework', 'uikit-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', '\n\n<p class="uk-column-medium-1-2">\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p class="uk-text-large">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\n\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p> \n\n<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 10, '2014-03-22 11:50:55', 322, '', '2015-12-14 14:37:53', 322, 0, '0000-00-00 00:00:00', '2014-03-22 11:50:55', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-dynamic-04.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-dynamic-04.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 44, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(55, 318, 'Widgetkit', 'widgetkit-extension-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', '\n\n<p class="uk-column-medium-1-2">\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p class="uk-text-large">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\n\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p> \n\n<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 10, '2014-02-14 11:50:55', 322, '', '2015-12-14 14:37:59', 322, 0, '0000-00-00 00:00:00', '2014-02-14 11:50:55', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-dynamic-05.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-dynamic-05.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 34, 7, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(56, 320, 'ZOO Extension', 'zoo-extension-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', '\n\n<p class="uk-column-medium-1-2">\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p class="uk-text-large">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\n\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p> \n\n<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 10, '2014-02-28 11:51:30', 322, '', '2015-12-14 14:38:05', 322, 0, '0000-00-00 00:00:00', '2014-02-28 11:51:30', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-06.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-06.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 31, 6, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(57, 322, 'Warp Framework', 'warp-framework-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', '\n\n<p class="uk-column-medium-1-2">\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p class="uk-text-large">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\n\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p> \n\n<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 10, '2014-03-12 11:50:55', 322, '', '2015-12-14 14:38:17', 322, 0, '0000-00-00 00:00:00', '2014-03-12 11:50:55', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-07.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-07.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 38, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(58, 324, 'Beautiful Icons', 'beautiful-icons-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', '\n\n<p class="uk-column-medium-1-2">\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p class="uk-text-large">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\n\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p> \n\n<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 10, '2014-03-15 11:50:30', 322, '', '2015-12-14 14:38:22', 322, 0, '0000-00-00 00:00:00', '2014-03-15 11:50:30', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-dynamic-08.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-dynamic-08.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 36, 4, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(59, 326, 'Joomla Templates', 'joomla-templates-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', '\n\n<p class="uk-column-medium-1-2">\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p class="uk-text-large">Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aeneanommodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\n\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. <br /><br />\n\nNullam dictum felis eu pede mollis pretium. Integer tincidunt. Crasfeugiat a, tellus. Phasellus viverra nulla ut metus varius laoreisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum.</p> \n\n<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc.</p>', 1, 10, '2014-04-02 11:50:02', 322, '', '2015-12-15 10:36:04', 322, 0, '0000-00-00 00:00:00', '2014-04-02 11:50:02', '0000-00-00 00:00:00', '{"image_intro":"images\\/yootheme\\/blog-dynamic-02.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-dynamic-02.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 91, 1, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(60, 355, 'Single Page Example', 'single-page', '<p>\n  Dictum lorem adipiscing augue vitae ante. Quis scelerisque sem urna pellentesque eu dolorum quisque ullamcorper. Pede nulla fringilla. Nec dolor purus elementum non mauris. Lacus aenean posuere.\n</p>\n\n<p>\n  Non a lacus. Arcu nunc vestibulum. Morbi reprehenderit nulla euismod quam adipiscing tempus amet suscipit leo fringilla amet nunc sit erat blandit aliquam urna. In fermentum vestibulum ut vulputate ultricies ac morbi vulputate et euismod erat. Sit enim erat. Nullam eu assumenda. Sit ante rhoncus donec vitae cras. Est ac ridiculus. Lacus justo volutpat. Felis dignissim at. Lectus adipiscing in. Eros eu felis.\n</p>', '', 1, 2, '2015-12-10 08:54:18', 322, '', '2015-12-10 09:30:26', 322, 0, '0000-00-00 00:00:00', '2015-12-10 08:54:18', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 0, '', '', 1, 56, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');

-- --------------------------------------------------------
DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE `#__contentitem_tag_map` (
  `type_alias` varchar(255) NOT NULL DEFAULT '',
  `core_content_id` int(10) unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table'
)  DEFAULT CHARSET=utf8 COMMENT='Maps items from content tables to tags';

--
-- Daten für Tabelle `#__contentitem_tag_map`
--

INSERT INTO `#__contentitem_tag_map` (`type_alias`, `core_content_id`, `content_item_id`, `tag_id`, `tag_date`, `type_id`) VALUES
('com_content.article', 6, 8, 3, '2015-12-07 16:57:13', 1),
('com_content.article', 6, 8, 6, '2015-12-07 16:57:13', 1),
('com_content.article', 7, 9, 6, '2015-12-07 16:50:02', 1),
('com_content.article', 7, 9, 8, '2015-12-07 16:50:02', 1),
('com_content.article', 8, 10, 22, '2015-12-07 16:52:25', 1),
('com_content.article', 8, 10, 23, '2015-12-07 16:52:25', 1),
('com_content.article', 9, 11, 2, '2015-12-07 16:51:14', 1),
('com_content.article', 9, 11, 24, '2015-12-07 16:51:14', 1),
('com_content.article', 10, 23, 5, '2015-12-07 16:51:40', 1),
('com_content.article', 10, 23, 25, '2015-12-07 16:51:40', 1),
('com_content.article', 11, 24, 5, '2015-12-07 16:56:57', 1),
('com_content.article', 11, 24, 7, '2015-12-07 16:56:57', 1),
('com_content.article', 5, 25, 20, '2015-12-07 16:51:00', 1),
('com_content.article', 5, 25, 21, '2015-12-07 16:51:00', 1),
('com_content.article', 12, 26, 6, '2015-12-07 16:50:54', 1),
('com_content.article', 12, 26, 9, '2015-12-07 16:50:54', 1),
('com_content.article', 4, 49, 14, '2015-12-07 16:51:34', 1),
('com_content.article', 4, 49, 19, '2015-12-07 16:51:34', 1),
('com_content.article', 13, 51, 14, '2015-12-14 14:37:33', 1),
('com_content.article', 13, 51, 19, '2015-12-14 14:37:33', 1),
('com_content.article', 14, 52, 6, '2015-12-14 14:37:39', 1),
('com_content.article', 14, 52, 9, '2015-12-14 14:37:39', 1),
('com_content.article', 15, 53, 20, '2015-12-14 14:37:46', 1),
('com_content.article', 15, 53, 21, '2015-12-14 14:37:46', 1),
('com_content.article', 16, 54, 5, '2015-12-14 14:37:53', 1),
('com_content.article', 16, 54, 7, '2015-12-14 14:37:53', 1),
('com_content.article', 17, 55, 5, '2015-12-14 14:37:59', 1),
('com_content.article', 17, 55, 25, '2015-12-14 14:37:59', 1),
('com_content.article', 18, 56, 2, '2015-12-14 14:38:05', 1),
('com_content.article', 18, 56, 24, '2015-12-14 14:38:05', 1),
('com_content.article', 19, 57, 22, '2015-12-14 14:38:17', 1),
('com_content.article', 19, 57, 23, '2015-12-14 14:38:17', 1),
('com_content.article', 20, 58, 6, '2015-12-14 14:38:22', 1),
('com_content.article', 20, 58, 8, '2015-12-14 14:38:22', 1),
('com_content.article', 21, 59, 3, '2015-12-15 10:36:04', 1),
('com_content.article', 21, 59, 6, '2015-12-15 10:36:04', 1),
('com_content.article', 22, 60, 21, '2015-12-10 09:30:26', 1),
('com_content.article', 22, 60, 26, '2015-12-10 09:30:26', 1),
('com_content.article', 22, 60, 27, '2015-12-10 09:30:26', 1);

-- --------------------------------------------------------
DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0'
)  DEFAULT CHARSET=utf8;

--
-- Daten für Tabelle `#__content_frontpage`
--

INSERT INTO `#__content_frontpage` (`content_id`, `ordering`) VALUES
(8, 28),
(9, 27),
(10, 26),
(11, 25),
(12, 24),
(23, 23),
(24, 22),
(25, 21),
(26, 20),
(32, 19),
(33, 18),
(34, 17),
(35, 16),
(36, 15),
(37, 14),
(38, 13),
(39, 12),
(40, 11),
(49, 10),
(51, 2),
(52, 3),
(53, 4),
(54, 5),
(55, 6),
(56, 7),
(57, 8),
(58, 9),
(59, 1);

-- --------------------------------------------------------
DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE `#__extensions` (
`extension_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `type` varchar(20) NOT NULL,
  `element` varchar(100) NOT NULL,
  `folder` varchar(100) NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '1',
  `access` int(10) unsigned DEFAULT NULL,
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` text NOT NULL,
  `params` text NOT NULL,
  `custom_data` text NOT NULL,
  `system_data` text NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0'
)  AUTO_INCREMENT=10032 DEFAULT CHARSET=utf8;

--
-- Daten für Tabelle `#__extensions`
--

INSERT INTO `#__extensions` (`extension_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(1, 'com_mailto', 'component', 'com_mailto', '', 0, 1, 1, 1, '{"name":"com_mailto","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MAILTO_XML_DESCRIPTION","group":"","filename":"mailto"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(2, 'com_wrapper', 'component', 'com_wrapper', '', 0, 1, 1, 1, '{"name":"com_wrapper","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_WRAPPER_XML_DESCRIPTION","group":"","filename":"wrapper"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(3, 'com_admin', 'component', 'com_admin', '', 1, 1, 1, 1, '{"name":"com_admin","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_ADMIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(4, 'com_banners', 'component', 'com_banners', '', 1, 1, 1, 0, '{"name":"com_banners","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_BANNERS_XML_DESCRIPTION","group":"","filename":"banners"}', '{"purchase_type":"3","track_impressions":"0","track_clicks":"0","metakey_prefix":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(5, 'com_cache', 'component', 'com_cache', '', 1, 1, 1, 1, '{"name":"com_cache","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CACHE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(6, 'com_categories', 'component', 'com_categories', '', 1, 1, 1, 1, '{"name":"com_categories","type":"component","creationDate":"December 2007","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CATEGORIES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(7, 'com_checkin', 'component', 'com_checkin', '', 1, 1, 1, 1, '{"name":"com_checkin","type":"component","creationDate":"Unknown","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CHECKIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(8, 'com_contact', 'component', 'com_contact', '', 1, 1, 1, 0, '{"name":"com_contact","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}', '{"contact_layout":"_:default","show_contact_category":"hide","show_contact_list":"0","presentation_style":"sliders","show_name":"1","show_position":"1","show_email":"0","show_street_address":"1","show_suburb":"1","show_state":"1","show_postcode":"1","show_country":"1","show_telephone":"1","show_mobile":"1","show_fax":"1","show_webpage":"1","show_misc":"1","show_image":"1","image":"","allow_vcard":"0","show_articles":"0","show_profile":"0","show_links":"0","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","contact_icons":"0","icon_address":"","icon_email":"","icon_telephone":"","icon_mobile":"","icon_fax":"","icon_misc":"","category_layout":"_:default","show_category_title":"1","show_description":"1","show_description_image":"0","maxLevel":"-1","show_empty_categories":"0","show_subcat_desc":"1","show_cat_items":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_items_cat":"1","show_pagination_limit":"1","show_headings":"1","show_position_headings":"1","show_email_headings":"0","show_telephone_headings":"1","show_mobile_headings":"0","show_fax_headings":"0","show_suburb_headings":"1","show_state_headings":"1","show_country_headings":"1","show_pagination":"2","show_pagination_results":"1","initial_sort":"ordering","show_email_form":"1","show_email_copy":"1","banned_email":"","banned_subject":"","banned_text":"","validate_session":"1","custom_reply":"0","redirect":"","show_feed_link":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(9, 'com_cpanel', 'component', 'com_cpanel', '', 1, 1, 1, 1, '{"name":"com_cpanel","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CPANEL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10, 'com_installer', 'component', 'com_installer', '', 1, 1, 1, 1, '{"name":"com_installer","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_INSTALLER_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(11, 'com_languages', 'component', 'com_languages', '', 1, 1, 1, 1, '{"name":"com_languages","type":"component","creationDate":"2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LANGUAGES_XML_DESCRIPTION","group":""}', '{"administrator":"en-GB","site":"en-GB"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(12, 'com_login', 'component', 'com_login', '', 1, 1, 1, 1, '{"name":"com_login","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(13, 'com_media', 'component', 'com_media', '', 1, 1, 0, 1, '{"name":"com_media","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MEDIA_XML_DESCRIPTION","group":"","filename":"media"}', '{"upload_extensions":"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS","upload_maxsize":"10","file_path":"images","image_path":"images","restrict_uploads":"1","allowed_media_usergroup":"3","check_mime":"1","image_extensions":"bmp,gif,jpg,png","ignore_extensions":"","upload_mime":"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip","upload_mime_illegal":"text\\/html","enable_flash":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(14, 'com_menus', 'component', 'com_menus', '', 1, 1, 1, 1, '{"name":"com_menus","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MENUS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(15, 'com_messages', 'component', 'com_messages', '', 1, 1, 1, 1, '{"name":"com_messages","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MESSAGES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(16, 'com_modules', 'component', 'com_modules', '', 1, 1, 1, 1, '{"name":"com_modules","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MODULES_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(17, 'com_newsfeeds', 'component', 'com_newsfeeds', '', 1, 1, 1, 0, '{"name":"com_newsfeeds","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}', '{"show_feed_image":"1","show_feed_description":"1","show_item_description":"1","feed_word_count":"0","show_headings":"1","show_name":"1","show_articles":"0","show_link":"1","show_description":"1","show_description_image":"1","display_num":"","show_pagination_limit":"1","show_pagination":"1","show_pagination_results":"1","show_cat_items":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(18, 'com_plugins', 'component', 'com_plugins', '', 1, 1, 1, 1, '{"name":"com_plugins","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_PLUGINS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(19, 'com_search', 'component', 'com_search', '', 1, 1, 1, 0, '{"name":"com_search","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_SEARCH_XML_DESCRIPTION","group":"","filename":"search"}', '{"enabled":"0","show_date":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(20, 'com_templates', 'component', 'com_templates', '', 1, 1, 1, 1, '{"name":"com_templates","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_TEMPLATES_XML_DESCRIPTION","group":""}', '{"template_positions_display":"0","upload_limit":"2","image_formats":"gif,bmp,jpg,jpeg,png","source_formats":"txt,less,ini,xml,js,php,css","font_formats":"woff,ttf,otf","compressed_formats":"zip"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(22, 'com_content', 'component', 'com_content', '', 1, 1, 0, 1, '{"name":"com_content","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}', '{"article_layout":"_:default","show_title":"1","link_titles":"1","show_intro":"1","info_block_position":"0","show_category":"0","link_category":"1","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"1","show_modify_date":"0","show_publish_date":"1","show_item_navigation":"0","show_vote":"0","show_readmore":"1","show_readmore_title":"1","readmore_limit":"100","show_tags":"1","show_icons":"1","show_print_icon":"0","show_email_icon":"0","show_hits":"1","show_noauth":"0","urls_position":"0","show_publishing_options":"1","show_article_options":"1","save_history":"0","history_limit":10,"show_urls_images_frontend":"1","show_urls_images_backend":"1","targeta":0,"targetb":0,"targetc":0,"float_intro":"none","float_fulltext":"none","category_layout":"_:blog","show_category_heading_title_text":"1","show_category_title":"0","show_description":"0","show_description_image":"0","maxLevel":"1","show_empty_categories":"0","show_no_articles":"1","show_subcat_desc":"1","show_cat_num_articles":"0","show_cat_tags":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_num_articles_cat":"1","num_leading_articles":"0","num_intro_articles":"5","num_columns":"1","num_links":"0","multi_column_order":"0","show_subcategory_content":"0","show_pagination_limit":"1","filter_field":"hide","show_headings":"1","list_show_date":"0","date_format":"","list_show_hits":"1","list_show_author":"1","orderby_pri":"order","orderby_sec":"rdate","order_date":"published","show_pagination":"2","show_pagination_results":"1","show_featured":"show","show_feed_link":"1","feed_summary":"0","feed_show_readmore":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(23, 'com_config', 'component', 'com_config', '', 1, 1, 0, 1, '{"name":"com_config","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONFIG_XML_DESCRIPTION","group":""}', '{"filters":{"1":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"9":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"6":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"7":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"2":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"3":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"4":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"5":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"8":{"filter_type":"NONE","filter_tags":"","filter_attributes":""}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(24, 'com_redirect', 'component', 'com_redirect', '', 1, 1, 0, 1, '{"name":"com_redirect","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_REDIRECT_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(25, 'com_users', 'component', 'com_users', '', 1, 1, 0, 1, '{"name":"com_users","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_USERS_XML_DESCRIPTION","group":"","filename":"users"}', '{"allowUserRegistration":"1","new_usertype":"2","guest_usergroup":"1","sendpassword":"1","useractivation":"1","mail_to_admin":"1","captcha":"","frontend_userparams":"1","site_language":"0","change_login_name":"0","reset_count":"10","reset_time":"1","minimum_length":"4","minimum_integers":"0","minimum_symbols":"0","minimum_uppercase":"0","save_history":"0","history_limit":5,"mailSubjectPrefix":"","mailBodySuffix":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(27, 'com_finder', 'component', 'com_finder', '', 1, 1, 0, 0, '', '{"show_description":"1","description_length":255,"allow_empty_query":"0","show_url":"0","show_autosuggest":"1","show_advanced":"1","expand_advanced":"0","show_date_filters":"0","sort_order":"relevance","sort_direction":"desc","highlight_terms":"1","opensearch_name":"","opensearch_description":"","batch_size":"50","memory_table_limit":30000,"title_multiplier":"1.7","text_multiplier":"0.7","meta_multiplier":"1.2","path_multiplier":"2.0","misc_multiplier":"0.3","stem":"1","stemmer":"porter_en"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(28, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', 1, 1, 0, 1, '{"legacy":false,"name":"com_joomlaupdate","type":"component","creationDate":"February 2012","author":"Joomla! Project","copyright":"(C) 2005 - 2012 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.2","description":"COM_JOOMLAUPDATE_XML_DESCRIPTION","group":""}', '{"updatesource":"sts","customurl":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(29, 'com_tags', 'component', 'com_tags', '', 1, 1, 1, 1, '{"name":"com_tags","type":"component","creationDate":"December 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"COM_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(30, 'com_contenthistory', 'component', 'com_contenthistory', '', 1, 1, 1, 0, '{"name":"com_contenthistory","type":"component","creationDate":"May 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_CONTENTHISTORY_XML_DESCRIPTION","group":"","filename":"contenthistory"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(31, 'com_ajax', 'component', 'com_ajax', '', 1, 1, 1, 0, '{"name":"com_ajax","type":"component","creationDate":"August 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_AJAX_XML_DESCRIPTION","group":"","filename":"ajax"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(32, 'com_postinstall', 'component', 'com_postinstall', '', 1, 1, 1, 1, '{"name":"com_postinstall","type":"component","creationDate":"September 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_POSTINSTALL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(100, 'PHPMailer', 'library', 'phpmailer', '', 0, 1, 1, 1, 'false', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(101, 'SimplePie', 'library', 'simplepie', '', 0, 1, 1, 1, '{"name":"SimplePie","type":"library","creationDate":"2004","author":"SimplePie","copyright":"Copyright (c) 2004-2009, Ryan Parman and Geoffrey Sneddon","authorEmail":"","authorUrl":"http:\\/\\/simplepie.org\\/","version":"1.2","description":"LIB_SIMPLEPIE_XML_DESCRIPTION","group":"","filename":"simplepie"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(102, 'phputf8', 'library', 'phputf8', '', 0, 1, 1, 1, '{"name":"phputf8","type":"library","creationDate":"2006","author":"Harry Fuecks","copyright":"Copyright various authors","authorEmail":"hfuecks@gmail.com","authorUrl":"http:\\/\\/sourceforge.net\\/projects\\/phputf8","version":"0.5","description":"LIB_PHPUTF8_XML_DESCRIPTION","group":"","filename":"phputf8"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(103, 'Joomla! Platform', 'library', 'joomla', '', 0, 1, 1, 1, '{"name":"Joomla! Platform","type":"library","creationDate":"2008","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"http:\\/\\/www.joomla.org","version":"13.1","description":"LIB_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{"mediaversion":"5216dbc060ec41882b5a96726635c39f"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(104, 'IDNA Convert', 'library', 'idna_convert', '', 0, 1, 1, 1, '{"name":"IDNA Convert","type":"library","creationDate":"2004","author":"phlyLabs","copyright":"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de","authorEmail":"phlymail@phlylabs.de","authorUrl":"http:\\/\\/phlylabs.de","version":"0.8.0","description":"LIB_IDNA_XML_DESCRIPTION","group":"","filename":"idna_convert"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(105, 'FOF', 'library', 'fof', '', 0, 1, 1, 1, '{"name":"FOF","type":"library","creationDate":"2015-04-22 13:15:32","author":"Nicholas K. Dionysopoulos \\/ Akeeba Ltd","copyright":"(C)2011-2015 Nicholas K. Dionysopoulos","authorEmail":"nicholas@akeebabackup.com","authorUrl":"https:\\/\\/www.akeebabackup.com","version":"2.4.3","description":"LIB_FOF_XML_DESCRIPTION","group":"","filename":"fof"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(106, 'PHPass', 'library', 'phpass', '', 0, 1, 1, 1, '{"name":"PHPass","type":"library","creationDate":"2004-2006","author":"Solar Designer","copyright":"","authorEmail":"solar@openwall.com","authorUrl":"http:\\/\\/www.openwall.com\\/phpass\\/","version":"0.3","description":"LIB_PHPASS_XML_DESCRIPTION","group":"","filename":"phpass"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(200, 'mod_articles_archive', 'module', 'mod_articles_archive', '', 0, 1, 1, 0, '{"name":"mod_articles_archive","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION","group":"","filename":"mod_articles_archive"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(201, 'mod_articles_latest', 'module', 'mod_articles_latest', '', 0, 1, 1, 0, '{"name":"mod_articles_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_NEWS_XML_DESCRIPTION","group":"","filename":"mod_articles_latest"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(202, 'mod_articles_popular', 'module', 'mod_articles_popular', '', 0, 1, 1, 0, '{"name":"mod_articles_popular","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_articles_popular"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(203, 'mod_banners', 'module', 'mod_banners', '', 0, 1, 1, 0, '{"name":"mod_banners","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BANNERS_XML_DESCRIPTION","group":"","filename":"mod_banners"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(204, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', 0, 1, 1, 1, '{"name":"mod_breadcrumbs","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BREADCRUMBS_XML_DESCRIPTION","group":"","filename":"mod_breadcrumbs"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(205, 'mod_custom', 'module', 'mod_custom', '', 0, 1, 1, 1, '{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":"","filename":"mod_custom"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(206, 'mod_feed', 'module', 'mod_feed', '', 0, 1, 1, 0, '{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":"","filename":"mod_feed"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(207, 'mod_footer', 'module', 'mod_footer', '', 0, 1, 1, 0, '{"name":"mod_footer","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FOOTER_XML_DESCRIPTION","group":"","filename":"mod_footer"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(208, 'mod_login', 'module', 'mod_login', '', 0, 1, 1, 1, '{"name":"mod_login","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":"","filename":"mod_login"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(209, 'mod_menu', 'module', 'mod_menu', '', 0, 1, 1, 1, '{"name":"mod_menu","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":"","filename":"mod_menu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(210, 'mod_articles_news', 'module', 'mod_articles_news', '', 0, 1, 1, 0, '{"name":"mod_articles_news","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_NEWS_XML_DESCRIPTION","group":"","filename":"mod_articles_news"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(211, 'mod_random_image', 'module', 'mod_random_image', '', 0, 1, 1, 0, '{"name":"mod_random_image","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RANDOM_IMAGE_XML_DESCRIPTION","group":"","filename":"mod_random_image"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(212, 'mod_related_items', 'module', 'mod_related_items', '', 0, 1, 1, 0, '{"name":"mod_related_items","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RELATED_XML_DESCRIPTION","group":"","filename":"mod_related_items"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(213, 'mod_search', 'module', 'mod_search', '', 0, 1, 1, 0, '{"name":"mod_search","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SEARCH_XML_DESCRIPTION","group":"","filename":"mod_search"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(214, 'mod_stats', 'module', 'mod_stats', '', 0, 1, 1, 0, '{"name":"mod_stats","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":"","filename":"mod_stats"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(215, 'mod_syndicate', 'module', 'mod_syndicate', '', 0, 1, 1, 1, '{"name":"mod_syndicate","type":"module","creationDate":"May 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SYNDICATE_XML_DESCRIPTION","group":"","filename":"mod_syndicate"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(216, 'mod_users_latest', 'module', 'mod_users_latest', '', 0, 1, 1, 0, '{"name":"mod_users_latest","type":"module","creationDate":"December 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_USERS_LATEST_XML_DESCRIPTION","group":"","filename":"mod_users_latest"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(217, 'mod_weblinks', 'module', 'mod_weblinks', '', 0, 1, 1, 0, '{"name":"mod_weblinks","type":"module","creationDate":"July 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WEBLINKS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(218, 'mod_whosonline', 'module', 'mod_whosonline', '', 0, 1, 1, 0, '{"name":"mod_whosonline","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WHOSONLINE_XML_DESCRIPTION","group":"","filename":"mod_whosonline"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(219, 'mod_wrapper', 'module', 'mod_wrapper', '', 0, 1, 1, 0, '{"name":"mod_wrapper","type":"module","creationDate":"October 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WRAPPER_XML_DESCRIPTION","group":"","filename":"mod_wrapper"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(220, 'mod_articles_category', 'module', 'mod_articles_category', '', 0, 1, 1, 0, '{"name":"mod_articles_category","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION","group":"","filename":"mod_articles_category"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(221, 'mod_articles_categories', 'module', 'mod_articles_categories', '', 0, 1, 1, 0, '{"name":"mod_articles_categories","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION","group":"","filename":"mod_articles_categories"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(222, 'mod_languages', 'module', 'mod_languages', '', 0, 1, 1, 1, '{"name":"mod_languages","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LANGUAGES_XML_DESCRIPTION","group":"","filename":"mod_languages"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(223, 'mod_finder', 'module', 'mod_finder', '', 0, 1, 0, 0, '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(300, 'mod_custom', 'module', 'mod_custom', '', 1, 1, 1, 1, '{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":"","filename":"mod_custom"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(301, 'mod_feed', 'module', 'mod_feed', '', 1, 1, 1, 0, '{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":"","filename":"mod_feed"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(302, 'mod_latest', 'module', 'mod_latest', '', 1, 1, 1, 0, '{"name":"mod_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_XML_DESCRIPTION","group":"","filename":"mod_latest"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(303, 'mod_logged', 'module', 'mod_logged', '', 1, 1, 1, 0, '{"name":"mod_logged","type":"module","creationDate":"January 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGGED_XML_DESCRIPTION","group":"","filename":"mod_logged"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(304, 'mod_login', 'module', 'mod_login', '', 1, 1, 1, 1, '{"name":"mod_login","type":"module","creationDate":"March 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":"","filename":"mod_login"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(305, 'mod_menu', 'module', 'mod_menu', '', 1, 1, 1, 0, '{"name":"mod_menu","type":"module","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":"","filename":"mod_menu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(306, 'mod_online', 'module', 'mod_online', '', 1, 1, 1, 0, '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(307, 'mod_popular', 'module', 'mod_popular', '', 1, 1, 1, 0, '{"name":"mod_popular","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_popular"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(308, 'mod_quickicon', 'module', 'mod_quickicon', '', 1, 1, 1, 1, '{"name":"mod_quickicon","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_QUICKICON_XML_DESCRIPTION","group":"","filename":"mod_quickicon"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(309, 'mod_status', 'module', 'mod_status', '', 1, 1, 1, 0, '{"name":"mod_status","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATUS_XML_DESCRIPTION","group":"","filename":"mod_status"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(310, 'mod_submenu', 'module', 'mod_submenu', '', 1, 1, 1, 0, '{"name":"mod_submenu","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SUBMENU_XML_DESCRIPTION","group":"","filename":"mod_submenu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(311, 'mod_title', 'module', 'mod_title', '', 1, 1, 1, 0, '{"name":"mod_title","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TITLE_XML_DESCRIPTION","group":"","filename":"mod_title"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(312, 'mod_toolbar', 'module', 'mod_toolbar', '', 1, 1, 1, 1, '{"name":"mod_toolbar","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TOOLBAR_XML_DESCRIPTION","group":"","filename":"mod_toolbar"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(313, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', 1, 1, 1, 0, '{"name":"mod_multilangstatus","type":"module","creationDate":"September 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MULTILANGSTATUS_XML_DESCRIPTION","group":"","filename":"mod_multilangstatus"}', '{"cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(314, 'mod_version', 'module', 'mod_version', '', 1, 1, 1, 0, '{"legacy":false,"name":"mod_version","type":"module","creationDate":"January 2012","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_VERSION_XML_DESCRIPTION","group":""}', '{"format":"short","product":"1","cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(315, 'mod_stats_admin', 'module', 'mod_stats_admin', '', 1, 1, 1, 0, '{"name":"mod_stats_admin","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":"","filename":"mod_stats_admin"}', '{"serverinfo":"0","siteinfo":"0","counter":"0","increase":"0","cache":"1","cache_time":"900","cachemode":"static"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(316, 'mod_tags_popular', 'module', 'mod_tags_popular', '', 0, 1, 1, 0, '{"name":"mod_tags_popular","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_tags_popular"}', '{"maximum":"5","timeframe":"alltime","owncache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(317, 'mod_tags_similar', 'module', 'mod_tags_similar', '', 0, 1, 1, 0, '{"name":"mod_tags_similar","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_SIMILAR_XML_DESCRIPTION","group":"","filename":"mod_tags_similar"}', '{"maximum":"5","matchtype":"any","owncache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(400, 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', 0, 0, 1, 0, '{"name":"plg_authentication_gmail","type":"plugin","creationDate":"February 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_GMAIL_XML_DESCRIPTION","group":"","filename":"gmail"}', '{"applysuffix":"0","suffix":"","verifypeer":"1","user_blacklist":""}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(401, 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', 0, 1, 1, 1, '{"name":"plg_authentication_joomla","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(402, 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', 0, 0, 1, 0, '{"name":"plg_authentication_ldap","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LDAP_XML_DESCRIPTION","group":"","filename":"ldap"}', '{"host":"","port":"389","use_ldapV3":"0","negotiate_tls":"0","no_referrals":"0","auth_method":"bind","base_dn":"","search_string":"","users_dn":"","username":"admin","password":"bobby7","ldap_fullname":"fullName","ldap_email":"mail","ldap_uid":"uid"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(403, 'plg_content_contact', 'plugin', 'contact', 'content', 0, 1, 1, 0, '{"name":"plg_content_contact","type":"plugin","creationDate":"January 2014","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.2","description":"PLG_CONTENT_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(404, 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', 0, 1, 1, 0, '{"name":"plg_content_emailcloak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION","group":"","filename":"emailcloak"}', '{"mode":"1"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(405, 'plg_content_geshi', 'plugin', 'geshi', 'content', 0, 0, 1, 0, '{"legacy":false,"name":"plg_content_geshi","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.","authorEmail":"","authorUrl":"qbnz.com\\/highlighter","version":"2.5.0","description":"PLG_CONTENT_GESHI_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(406, 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', 0, 1, 1, 0, '{"name":"plg_content_loadmodule","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOADMODULE_XML_DESCRIPTION","group":"","filename":"loadmodule"}', '{"style":"none"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(407, 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', 0, 1, 1, 0, '{"name":"plg_content_pagebreak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION","group":"","filename":"pagebreak"}', '{"title":"1","multipage_toc":"1","showall":"1"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(408, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', 0, 1, 1, 0, '{"name":"plg_content_pagenavigation","type":"plugin","creationDate":"January 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_PAGENAVIGATION_XML_DESCRIPTION","group":"","filename":"pagenavigation"}', '{"position":"1"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(409, 'plg_content_vote', 'plugin', 'vote', 'content', 0, 1, 1, 0, '{"name":"plg_content_vote","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_VOTE_XML_DESCRIPTION","group":"","filename":"vote"}', '{}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(410, 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_codemirror","type":"plugin","creationDate":"28 March 2011","author":"Marijn Haverbeke","copyright":"Copyright (C) 2014 by Marijn Haverbeke <marijnh@gmail.com> and others","authorEmail":"marijnh@gmail.com","authorUrl":"http:\\/\\/codemirror.net\\/","version":"5.6","description":"PLG_CODEMIRROR_XML_DESCRIPTION","group":"","filename":"codemirror"}', '{"lineNumbers":"1","lineWrapping":"1","matchTags":"1","matchBrackets":"1","marker-gutter":"1","autoCloseTags":"1","autoCloseBrackets":"1","autoFocus":"1","theme":"default","tabmode":"indent"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(411, 'plg_editors_none', 'plugin', 'none', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_none","type":"plugin","creationDate":"September 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_NONE_XML_DESCRIPTION","group":"","filename":"none"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(412, 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', 0, 1, 1, 0, '{"name":"plg_editors_tinymce","type":"plugin","creationDate":"2005-2014","author":"Moxiecode Systems AB","copyright":"Moxiecode Systems AB","authorEmail":"N\\/A","authorUrl":"tinymce.moxiecode.com","version":"4.1.7","description":"PLG_TINY_XML_DESCRIPTION","group":"","filename":"tinymce"}', '{"mode":"1","skin":"0","compressed":"0","cleanup_startup":"0","cleanup_save":"2","entity_encoding":"raw","lang_mode":"0","lang_code":"en","text_direction":"ltr","content_css":"1","content_css_custom":"","relative_urls":"1","newlines":"0","invalid_elements":"script,applet,iframe","extended_elements":",@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight],@[data-lightbox],@[data-spotlight]","toolbar":"top","toolbar_align":"left","html_height":"550","html_width":"750","element_path":"1","fonts":"1","paste":"1","searchreplace":"1","insertdate":"1","format_date":"%Y-%m-%d","inserttime":"1","format_time":"%H:%M:%S","colors":"1","table":"1","smilies":"1","media":"1","hr":"1","directionality":"1","fullscreen":"1","style":"1","layer":"1","xhtmlxtras":"1","visualchars":"1","nonbreaking":"1","template":"1","blockquote":"1","wordcount":"1","advimage":"1","advlink":"1","autosave":"1","contextmenu":"1","inlinepopups":"1","safari":"0","custom_plugin":"","custom_button":""}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(413, 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', 0, 1, 1, 1, '{"name":"plg_editors-xtd_article","type":"plugin","creationDate":"October 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_ARTICLE_XML_DESCRIPTION","group":"","filename":"article"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(414, 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_image","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_IMAGE_XML_DESCRIPTION","group":"","filename":"image"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(415, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_pagebreak","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION","group":"","filename":"pagebreak"}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0);
INSERT INTO `#__extensions` (`extension_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(416, 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_readmore","type":"plugin","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_READMORE_XML_DESCRIPTION","group":"","filename":"readmore"}', '{}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(417, 'plg_search_categories', 'plugin', 'categories', 'search', 0, 1, 1, 0, '{"name":"plg_search_categories","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION","group":"","filename":"categories"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(418, 'plg_search_contacts', 'plugin', 'contacts', 'search', 0, 1, 1, 0, '{"name":"plg_search_contacts","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTACTS_XML_DESCRIPTION","group":"","filename":"contacts"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(419, 'plg_search_content', 'plugin', 'content', 'search', 0, 1, 1, 0, '{"name":"plg_search_content","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(420, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', 0, 1, 1, 0, '{"name":"plg_search_newsfeeds","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(421, 'plg_search_weblinks', 'plugin', 'weblinks', 'search', 0, 1, 1, 0, '{"name":"plg_search_weblinks","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(422, 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', 0, 0, 1, 1, '{"name":"plg_system_languagefilter","type":"plugin","creationDate":"July 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION","group":"","filename":"languagefilter"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(423, 'plg_system_p3p', 'plugin', 'p3p', 'system', 0, 1, 1, 0, '{"name":"plg_system_p3p","type":"plugin","creationDate":"September 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_P3P_XML_DESCRIPTION","group":"","filename":"p3p"}', '{"headers":"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(424, 'plg_system_cache', 'plugin', 'cache', 'system', 0, 0, 1, 1, '{"name":"plg_system_cache","type":"plugin","creationDate":"February 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CACHE_XML_DESCRIPTION","group":"","filename":"cache"}', '{"browsercache":"0","cachetime":"15"}', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(425, 'plg_system_debug', 'plugin', 'debug', 'system', 0, 0, 1, 0, '{"name":"plg_system_debug","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_DEBUG_XML_DESCRIPTION","group":"","filename":"debug"}', '{"profile":"1","queries":"1","memory":"1","language_files":"1","language_strings":"1","strip-first":"1","strip-prefix":"","strip-suffix":""}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(426, 'plg_system_log', 'plugin', 'log', 'system', 0, 1, 1, 1, '{"name":"plg_system_log","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOG_XML_DESCRIPTION","group":"","filename":"log"}', '{}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(427, 'plg_system_redirect', 'plugin', 'redirect', 'system', 0, 1, 1, 1, '{"name":"plg_system_redirect","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION","group":"","filename":"redirect"}', '{}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(428, 'plg_system_remember', 'plugin', 'remember', 'system', 0, 1, 1, 1, '{"name":"plg_system_remember","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_REMEMBER_XML_DESCRIPTION","group":"","filename":"remember"}', '{}', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(429, 'plg_system_sef', 'plugin', 'sef', 'system', 0, 1, 1, 0, '{"name":"plg_system_sef","type":"plugin","creationDate":"December 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEF_XML_DESCRIPTION","group":"","filename":"sef"}', '{}', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(430, 'plg_system_logout', 'plugin', 'logout', 'system', 0, 1, 1, 1, '{"name":"plg_system_logout","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION","group":"","filename":"logout"}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(431, 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', 0, 0, 1, 0, '{"name":"plg_user_contactcreator","type":"plugin","creationDate":"August 2009","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTACTCREATOR_XML_DESCRIPTION","group":"","filename":"contactcreator"}', '{"autowebpage":"","category":"34","autopublish":"0"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(432, 'plg_user_joomla', 'plugin', 'joomla', 'user', 0, 1, 1, 0, '{"name":"plg_user_joomla","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{"autoregister":"1"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(433, 'plg_user_profile', 'plugin', 'profile', 'user', 0, 0, 1, 0, '{"name":"plg_user_profile","type":"plugin","creationDate":"January 2008","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_PROFILE_XML_DESCRIPTION","group":"","filename":"profile"}', '{"register-require_address1":"1","register-require_address2":"1","register-require_city":"1","register-require_region":"1","register-require_country":"1","register-require_postal_code":"1","register-require_phone":"1","register-require_website":"1","register-require_favoritebook":"1","register-require_aboutme":"1","register-require_tos":"1","register-require_dob":"1","profile-require_address1":"1","profile-require_address2":"1","profile-require_city":"1","profile-require_region":"1","profile-require_country":"1","profile-require_postal_code":"1","profile-require_phone":"1","profile-require_website":"1","profile-require_favoritebook":"1","profile-require_aboutme":"1","profile-require_tos":"1","profile-require_dob":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(434, 'plg_extension_joomla', 'plugin', 'joomla', 'extension', 0, 1, 1, 1, '{"name":"plg_extension_joomla","type":"plugin","creationDate":"May 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(435, 'plg_content_joomla', 'plugin', 'joomla', 'content', 0, 1, 1, 0, '{"name":"plg_content_joomla","type":"plugin","creationDate":"November 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(436, 'plg_system_languagecode', 'plugin', 'languagecode', 'system', 0, 0, 1, 0, '{"name":"plg_system_languagecode","type":"plugin","creationDate":"November 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION","group":"","filename":"languagecode"}', '{}', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(437, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', 0, 1, 1, 1, '{"name":"plg_quickicon_joomlaupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION","group":"","filename":"joomlaupdate"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(438, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', 0, 1, 1, 1, '{"name":"plg_quickicon_extensionupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION","group":"","filename":"extensionupdate"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(439, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', 0, 1, 1, 0, '{"name":"plg_captcha_recaptcha","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.4.0","description":"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION","group":"","filename":"recaptcha"}', '{"public_key":"","private_key":"","theme":"clean"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(440, 'plg_system_highlight', 'plugin', 'highlight', 'system', 0, 1, 1, 0, '', '{}', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(441, 'plg_content_finder', 'plugin', 'finder', 'content', 0, 0, 1, 0, '{"legacy":false,"name":"plg_content_finder","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"1.7.0","description":"PLG_CONTENT_FINDER_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(442, 'plg_finder_categories', 'plugin', 'categories', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_categories","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CATEGORIES_XML_DESCRIPTION","group":"","filename":"categories"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(443, 'plg_finder_contacts', 'plugin', 'contacts', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_contacts","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTACTS_XML_DESCRIPTION","group":"","filename":"contacts"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(444, 'plg_finder_content', 'plugin', 'content', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_content","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(445, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_newsfeeds","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}', '{}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(446, 'plg_finder_weblinks', 'plugin', 'weblinks', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_weblinks","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_WEBLINKS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(447, 'plg_finder_tags', 'plugin', 'tags', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_tags","type":"plugin","creationDate":"February 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(448, 'plg_twofactorauth_totp', 'plugin', 'totp', 'twofactorauth', 0, 0, 1, 0, '{"name":"plg_twofactorauth_totp","type":"plugin","creationDate":"August 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION","group":"","filename":"totp"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(449, 'plg_authentication_cookie', 'plugin', 'cookie', 'authentication', 0, 1, 1, 0, '{"name":"plg_authentication_cookie","type":"plugin","creationDate":"July 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_COOKIE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(450, 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', 'twofactorauth', 0, 0, 1, 0, '{"name":"plg_twofactorauth_yubikey","type":"plugin","creationDate":"September 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION","group":"","filename":"yubikey"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(451, 'plg_search_tags', 'plugin', 'tags', 'search', 0, 0, 1, 0, '{"name":"plg_search_tags","type":"plugin","creationDate":"March 2014","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}', '{"search_limit":"50","show_tagged_items":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(504, 'hathor', 'template', 'hathor', '', 1, 1, 1, 0, '{"name":"hathor","type":"template","creationDate":"May 2010","author":"Andrea Tarr","copyright":"Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.","authorEmail":"hathor@tarrconsulting.com","authorUrl":"http:\\/\\/www.tarrconsulting.com","version":"3.0.0","description":"TPL_HATHOR_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"showSiteName":"0","colourChoice":"0","boldText":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(600, 'English (en-GB)', 'language', 'en-GB', '', 0, 1, 1, 1, '{"name":"English (en-GB)","type":"language","creationDate":"2013-03-07","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.4.3","description":"en-GB site language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(601, 'English (en-GB)', 'language', 'en-GB', '', 1, 1, 1, 1, '{"name":"English (en-GB)","type":"language","creationDate":"2013-03-07","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.4.3","description":"en-GB administrator language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(700, 'files_joomla', 'file', 'joomla', '', 0, 1, 1, 1, '{"name":"files_joomla","type":"file","creationDate":"December 2015","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.4.8","description":"FILES_JOOMLA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10000, 'yoo_avanti', 'template', 'yoo_avanti', '', 0, 1, 1, 0, '{"legacy":false,"name":"yoo_avanti","type":"template","creationDate":"January 2016","author":"YOOtheme","copyright":"Copyright (C) YOOtheme GmbH","authorEmail":"info@yootheme.com","authorUrl":"http:\\/\\/www.yootheme.com","version":"1.0.0","description":"Avanti is the January 2016 theme of the YOOtheme club. It is based on YOOtheme''s Warp theme framework. NOTE: It is not free or public. This theme is for members of the YOOtheme club only.","group":""}', '{"config":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10001, 'Widgetkit', 'module', 'mod_widgetkit', '', 0, 1, 0, 0, '{"name":"Widgetkit","type":"module","creationDate":"January 2016","author":"YOOtheme","copyright":"Copyright (C) YOOtheme GmbH","authorEmail":"info@yootheme.com","authorUrl":"http:\\/\\/yootheme.com","version":"2.5.3","description":"A widget toolkit by YOOtheme.","group":"","filename":"mod_widgetkit"}', '{"widget_id":"","moduleclass_sfx":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10006, 'PKG_JOOMLA', 'package', 'pkg_joomla', '', 0, 1, 1, 1, '{"legacy":false,"name":"PKG_JOOMLA","type":"package","creationDate":"2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"http:\\/\\/www.joomla.org","version":"2.5.0","description":"PKG_JOOMLA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10007, 'System - Widgetkit ZOO', 'plugin', 'widgetkit_zoo', 'system', 0, 1, 1, 0, '{"name":"System - Widgetkit ZOO","type":"plugin","creationDate":"January 2016","author":"YOOtheme","copyright":"Copyright (C) YOOtheme GmbH","authorEmail":"info@yootheme.com","authorUrl":"http:\\/\\/yootheme.com","version":"2.5.3","description":"A widget toolkit by YOOtheme.","group":"","filename":"widgetkit_zoo"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10023, 'isis', 'template', 'isis', '', 1, 1, 1, 0, '{"name":"isis","type":"template","creationDate":"3\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_ISIS_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"templateColor":"","logoFile":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10024, 'protostar', 'template', 'protostar', '', 0, 1, 1, 0, '{"name":"protostar","type":"template","creationDate":"4\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_PROTOSTAR_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"templateColor":"","logoFile":"","googleFont":"1","googleFontName":"Open+Sans","fluidContainer":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10025, 'beez3', 'template', 'beez3', '', 0, 1, 1, 0, '{"name":"beez3","type":"template","creationDate":"25 November 2009","author":"Angie Radtke","copyright":"Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.","authorEmail":"a.radtke@derauftritt.de","authorUrl":"http:\\/\\/www.der-auftritt.de","version":"3.1.0","description":"TPL_BEEZ3_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"wrapperSmall":"53","wrapperLarge":"72","sitetitle":"","sitedescription":"","navposition":"center","templatecolor":"nature"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10026, 'com_widgetkit', 'component', 'com_widgetkit', '', 1, 1, 0, 0, '{"name":"com_widgetkit","type":"component","creationDate":"January 2016","author":"YOOtheme","copyright":"Copyright (C) YOOtheme GmbH","authorEmail":"info@yootheme.com","authorUrl":"http:\\/\\/yootheme.com","version":"2.5.3","description":"A widget toolkit by YOOtheme.","group":"","filename":"widgetkit"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10027, 'Content - Widgetkit', 'plugin', 'widgetkit', 'content', 0, 1, 1, 0, '{"name":"Content - Widgetkit","type":"plugin","creationDate":"January 2016","author":"YOOtheme","copyright":"Copyright (C) YOOtheme GmbH","authorEmail":"info@yootheme.com","authorUrl":"http:\\/\\/yootheme.com","version":"2.5.3","description":"A widget toolkit by YOOtheme.","group":"","filename":"widgetkit"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10028, 'Editors-XTD - Widgetkit', 'plugin', 'widgetkit', 'editors-xtd', 0, 1, 1, 0, '{"name":"Editors-XTD - Widgetkit","type":"plugin","creationDate":"January 2016","author":"YOOtheme","copyright":"Copyright (C) YOOtheme GmbH","authorEmail":"info@yootheme.com","authorUrl":"http:\\/\\/yootheme.com","version":"2.5.3","description":"A widget toolkit by YOOtheme.","group":"","filename":"widgetkit"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10029, 'System - Widgetkit K2', 'plugin', 'widgetkit_k2', 'system', 0, 0, 1, 0, '{"name":"System - Widgetkit K2","type":"plugin","creationDate":"January 2016","author":"YOOtheme","copyright":"Copyright (C) YOOtheme GmbH","authorEmail":"info@yootheme.com","authorUrl":"http:\\/\\/yootheme.com","version":"2.5.3","description":"A widget toolkit by YOOtheme.","group":"","filename":"widgetkit_k2"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10030, 'Installer - YOOtheme', 'plugin', 'yootheme', 'installer', 0, 1, 1, 0, '{"name":"Installer - YOOtheme","type":"plugin","creationDate":"December 2014","author":"YOOtheme","copyright":"Copyright (C) YOOtheme GmbH","authorEmail":"info@yootheme.com","authorUrl":"http:\\/\\/yootheme.com","version":"1.0.0","description":"PLG_INSTALLER_YOOTHEME_DESCRIPTION","group":"","filename":"yootheme"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10031, 'Widgetkit', 'package', 'pkg_widgetkit', '', 0, 1, 1, 0, '{"name":"Widgetkit","type":"package","creationDate":"January 2016","author":"YOOtheme","copyright":"Copyright (C) YOOtheme GmbH","authorEmail":"info@yootheme.com","authorUrl":"http:\\/\\/yootheme.com","version":"2.5.3","description":"A widget toolkit by YOOtheme.","group":"","filename":"pkg_widgetkit"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0);

-- --------------------------------------------------------
DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE `#__menu` (
`id` int(11) NOT NULL,
  `menutype` varchar(24) NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(1024) NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) unsigned DEFAULT NULL,
  `img` varchar(255) NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0'
)  AUTO_INCREMENT=272 DEFAULT CHARSET=utf8;

--
-- Daten für Tabelle `#__menu`
--

INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, 0, '0000-00-00 00:00:00', 0, 0, '', 0, '', 0, 107, 0, '*', 0),
(2, 'menu', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 0, 1, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 49, 58, 0, '*', 1),
(3, 'menu', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', 0, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 50, 51, 0, '*', 1),
(4, 'menu', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', 0, 2, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-cat', 0, '', 52, 53, 0, '*', 1),
(5, 'menu', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 0, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-clients', 0, '', 54, 55, 0, '*', 1),
(6, 'menu', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 0, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-tracks', 0, '', 56, 57, 0, '*', 1),
(7, 'menu', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 0, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 67, 70, 0, '*', 1),
(8, 'menu', 'com_contact', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', 0, 7, 2, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 68, 69, 0, '*', 1),
(16, 'menu', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', 0, 1, 1, 24, 0, '0000-00-00 00:00:00', 0, 0, 'class:redirect', 0, '', 73, 74, 0, '*', 1),
(17, 'menu', 'com_search', 'Search', '', 'Search', 'index.php?option=com_search', 'component', 0, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 0, 'class:search', 0, '', 71, 72, 0, '*', 1),
(21, 'menu', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 0, 1, 1, 27, 0, '0000-00-00 00:00:00', 0, 0, 'class:finder', 0, '', 65, 66, 0, '*', 1),
(22, 'menu', 'com_joomlaupdate', 'Joomla! Update', '', 'Joomla! Update', 'index.php?option=com_joomlaupdate', 'component', 0, 1, 1, 28, 0, '0000-00-00 00:00:00', 0, 0, 'class:joomlaupdate', 0, '', 61, 62, 0, '*', 1),
(23, 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags', 'component', 0, 1, 1, 29, 0, '0000-00-00 00:00:00', 0, 1, 'class:tags', 0, '', 63, 64, 0, '', 1),
(103, 'mainmenu', 'Layouts', 'layouts', '', 'theme-features/layouts', 'index.php?option=com_content&view=article&id=1', 'component', 1, 241, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"0","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 24, 25, 0, '*', 0),
(104, 'mainmenu', 'UIkit', 'uikit', '', 'theme-features/uikit', 'index.php?option=com_content&view=article&id=4', 'component', 1, 241, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"","show_intro":"","info_block_position":"","show_category":"0","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 26, 27, 0, '*', 0),
(108, 'footermenu', 'Blog', 'blog-2', '', 'blog-2', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"aliasoptions":"214","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 3, 4, 0, '*', 0),
(110, 'footermenu', 'Theme', 'theme-2', '', 'theme-2', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"241","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 7, 8, 0, '*', 0),
(111, 'sidebarmenu', 'Sample Levels', 'sample-levels', '', 'sample-levels', 'index.php?option=com_content&view=article&id=5', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 75, 86, 0, '*', 0),
(112, 'sidebarmenu', 'Level 2', 'level-2', '', 'sample-levels/level-2', 'index.php?option=com_content&view=article&id=5', 'component', 1, 111, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 76, 77, 0, '*', 0),
(113, 'sidebarmenu', 'Level 2', 'level-21', '', 'sample-levels/level-21', 'index.php?option=com_content&view=article&id=5', 'component', 1, 111, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 78, 83, 0, '*', 0),
(114, 'sidebarmenu', 'Level 3', 'level-3', '', 'sample-levels/level-21/level-3', 'index.php?option=com_content&view=article&id=5', 'component', 1, 113, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 79, 82, 0, '*', 0),
(115, 'sidebarmenu', 'Level 4', 'level-4', '', 'sample-levels/level-21/level-3/level-4', 'index.php?option=com_content&view=article&id=5', 'component', 1, 114, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 80, 81, 0, '*', 0),
(116, 'sidebarmenu', 'Level 2', 'level-22', '', 'sample-levels/level-22', 'index.php?option=com_content&view=article&id=5', 'component', 1, 111, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 84, 85, 0, '*', 0),
(117, 'sidebarmenu', 'Accordion A', 'accordion-a', '', 'accordion-a', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1}', 87, 94, 0, '*', 0),
(118, 'sidebarmenu', 'Level 2', 'level-2', '', 'accordion-a/level-2', 'index.php?option=com_content&view=article&id=5', 'component', 1, 117, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 88, 89, 0, '*', 0),
(119, 'sidebarmenu', 'Level 2', 'level-21', '', 'accordion-a/level-21', 'index.php?option=com_content&view=article&id=5', 'component', 1, 117, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 92, 93, 0, '*', 0),
(120, 'sidebarmenu', 'Level 2', 'level-22', '', 'accordion-a/level-22', 'index.php?option=com_content&view=article&id=5', 'component', 1, 117, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 90, 91, 0, '*', 0),
(121, 'sidebarmenu', 'Accordion B', 'accordion-b', '', 'accordion-b', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1}', 95, 100, 0, '*', 0),
(122, 'sidebarmenu', 'Level 2', 'level-2', '', 'accordion-b/level-2', 'index.php?option=com_content&view=article&id=5', 'component', 1, 121, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 96, 97, 0, '*', 0),
(123, 'sidebarmenu', 'Level 2', 'level-21', '', 'accordion-b/level-21', 'index.php?option=com_content&view=article&id=5', 'component', 1, 121, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 98, 99, 0, '*', 0),
(189, 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_content&view=article&id=7', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 7, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 9, 22, 1, '*', 0),
(190, 'mainmenu', 'Minimal', '2013-06-20-08-52-12', '', 'home/2013-06-20-08-52-12', '?style=minimal', 'url', 1, 189, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 12, 13, 0, '*', 0),
(191, 'mainmenu', 'Colorful', '2013-06-20-08-52-35', '', 'home/2013-06-20-08-52-35', '?style=colorful', 'url', 1, 189, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 16, 17, 0, '*', 0),
(193, 'mainmenu', 'Urban', '2013-06-20-08-52-53', '', 'home/2013-06-20-08-52-53', '?style=urban', 'url', 1, 189, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 18, 19, 0, '*', 0),
(194, 'mainmenu', 'Noble', '2013-06-20-08-52-54', '', 'home/2013-06-20-08-52-54', '?style=noble', 'url', 1, 189, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 14, 15, 0, '*', 0),
(196, 'mainmenu', 'Modern', '2013-06-20-08-52-56', '', 'home/2013-06-20-08-52-56', '?style=modern', 'url', 1, 189, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 20, 21, 0, '*', 0),
(202, 'main', 'com_postinstall', 'Post-installation messages', '', 'Post-installation messages', 'index.php?option=com_postinstall', 'component', 0, 1, 1, 32, 0, '0000-00-00 00:00:00', 0, 1, 'class:postinstall', 0, '', 59, 60, 0, '*', 1),
(210, 'mainmenu', 'Widgetkit', 'widgetkit', '', 'theme-features/widgetkit', 'index.php?option=com_content&view=article&id=13', 'component', 1, 241, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"","show_intro":"","info_block_position":"","show_category":"0","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 28, 29, 0, '*', 0),
(211, 'mainmenu', 'Blog', 'blog', '', 'blog', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu_image":"","menu_text":1}', 43, 48, 0, '*', 0),
(214, 'mainmenu', 'Blog Featured', 'blog-featured', '', 'blog/blog-featured', 'index.php?option=com_content&view=category&layout=blog&id=7', 'component', 1, 211, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_featured":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 46, 47, 0, '*', 0),
(217, 'mainmenu', 'Gallery', 'gallery', '', 'work/gallery', 'index.php?option=com_content&view=article&id=28', 'component', 1, 263, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_title":"0","link_titles":"","show_intro":"","info_block_position":"","show_category":"0","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 34, 35, 0, '*', 0),
(236, 'hidden', 'Blog Dynamic', 'blog-dynamic', '', 'blog-dynamic', 'index.php?option=com_content&view=category&layout=blog&id=10', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_featured":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 101, 102, 0, '*', 0),
(240, 'mainmenu', 'Default', '2015-04-22-08-39-02', '', 'home/2015-04-22-08-39-02', '?style=default', 'url', 1, 189, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 10, 11, 0, '*', 0),
(241, 'mainmenu', 'Theme', 'theme-features', '', 'theme-features', 'index.php?option=com_content&view=article&id=6', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"","show_intro":"","info_block_position":"","show_category":"0","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 23, 30, 0, '*', 0),
(244, 'mainmenu', 'Blog Dynamic', 'blog-dynamic', '', 'blog/blog-dynamic', 'index.php?option=com_content&view=article&id=41', 'component', 1, 211, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"","show_intro":"","info_block_position":"","show_category":"0","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 44, 45, 0, '*', 0),
(256, 'mainmenu', 'Portfolio', 'portfolio', '', 'work/portfolio', 'index.php?option=com_content&view=article&id=46', 'component', 1, 263, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 32, 33, 0, '*', 0),
(257, 'mainmenu', 'Services', 'services', '', 'services', 'index.php?option=com_content&view=article&id=47', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 39, 40, 0, '*', 0),
(258, 'mainmenu', 'Company', 'company', '', 'company', 'index.php?option=com_content&view=article&id=48', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_title":"1","link_titles":"","show_intro":"","info_block_position":"","show_category":"0","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 41, 42, 0, '*', 0),
(261, 'hidden', 'Search', 'search', '', 'search', 'index.php?option=com_content&view=article&id=50', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 103, 104, 0, '*', 0),
(263, 'mainmenu', 'Work', 'work', '', 'work', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu_image":"","menu_text":1}', 31, 38, 0, '*', 0),
(264, 'footermenu', 'Home', '2015-11-25-13-04-19', '', '2015-11-25-13-04-19', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"aliasoptions":"189","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 1, 2, 0, '*', 0),
(265, 'footermenu', 'Company', 'company-2', '', 'company-2', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"aliasoptions":"258","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 5, 6, 0, '*', 0),
(269, 'mainmenu', 'Single Page', 'single-page', '', 'work/single-page', 'index.php?option=com_content&view=article&id=60', 'component', 1, 263, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 36, 37, 0, '*', 0),
(271, 'main', 'COM_WIDGETKIT', 'com-widgetkit', '', 'com-widgetkit', 'index.php?option=com_widgetkit', 'component', 0, 1, 1, 10026, 0, '0000-00-00 00:00:00', 0, 1, 'class:widgetkit', 0, '{}', 105, 106, 0, '', 1);

-- --------------------------------------------------------
DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE `#__menu_types` (
`id` int(10) unsigned NOT NULL,
  `menutype` varchar(24) NOT NULL,
  `title` varchar(48) NOT NULL,
  `description` varchar(255) NOT NULL DEFAULT ''
)  AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Daten für Tabelle `#__menu_types`
--

INSERT INTO `#__menu_types` (`id`, `menutype`, `title`, `description`) VALUES
(1, 'mainmenu', 'Main Menu', 'The main menu for the site'),
(2, 'footermenu', 'Footer Menu', ''),
(3, 'sidebarmenu', 'Sidebar Menu', ''),
(4, 'hidden', 'Blog Dynamic', '');

-- --------------------------------------------------------
DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE `#__modules` (
`id` int(11) NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) DEFAULT NULL,
  `access` int(10) unsigned DEFAULT NULL,
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `params` text NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL
)  AUTO_INCREMENT=267 DEFAULT CHARSET=utf8;

--
-- Daten für Tabelle `#__modules`
--

INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(1, 0, 'Main Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"mainmenu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(2, 0, 'Login', '', '', 1, 'login', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 0, 'Popular Articles', '', '', 3, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_popular', 3, 1, '{"count":"5","catid":"","user_id":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(4, 0, 'Recently Added Articles', '', '', 4, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_latest', 3, 1, '{"count":"5","ordering":"c_dsc","catid":"","user_id":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(6, 0, 'Unread Messages', '', '', 1, 'header', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_unread', 3, 1, '', 1, '*'),
(7, 0, 'Online Users', '', '', 2, 'header', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_online', 3, 1, '', 1, '*'),
(8, 0, 'Toolbar', '', '', 1, 'toolbar', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 0, 'Quick Icons', '', '', 1, 'icon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_quickicon', 3, 1, '', 1, '*'),
(10, 0, 'Logged-in Users', '', '', 2, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_logged', 3, 1, '{"count":"5","name":"1","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(12, 0, 'Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 3, 1, '{"layout":"","moduleclass_sfx":"","shownew":"1","showhelp":"1","cache":"0"}', 1, '*'),
(13, 0, 'Admin Submenu', '', '', 1, 'submenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 0, 'User Status', '', '', 2, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_status', 3, 1, '', 1, '*'),
(15, 0, 'Title', '', '', 1, 'title', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_title', 3, 1, '', 1, '*'),
(17, 76, 'Breadcrumbs', '', '', 1, 'breadcrumbs', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_breadcrumbs', 1, 1, '{"showHere":"1","showHome":"1","homeText":"Home","showLast":"1","separator":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(19, 77, 'Bottom A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.', 13, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(20, 78, 'Bottom A', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 14, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(21, 79, 'Bottom A', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 15, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(27, 85, 'Bottom B', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 7, 'bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(28, 86, 'Bottom B', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 6, 'bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(29, 87, 'Bottom B', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 5, 'bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(30, 88, 'Bottom B', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 8, 'bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(34, 92, 'Main Bottom', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 1, 'main-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(35, 93, 'Main Bottom', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 2, 'main-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(36, 94, ' Main Top', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 1, 'main-top', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(37, 95, 'Main Top', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 1, 'main-top', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(38, 96, 'Logo', '', '<img src="images/yootheme/demo/default/logo.svg" width="40" height="40" alt="Demo" class="uk-margin-small-right"> Avanti', 1, 'logo', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(40, 98, 'Search', '', '', 1, 'search', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 1, '{"label":"","width":"20","text":"","button":"0","button_pos":"right","imagebutton":"0","button_text":"","opensearch":"1","opensearch_title":"","set_itemid":"261","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(42, 0, 'Sidebar Menu', '', '', 1, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"sidebarmenu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(43, 101, 'Sidebar A', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 3, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(44, 102, 'Sidebar A', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 2, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(57, 109, 'Sidebar B', '', '<p class="uk-margin-bottom">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam</p>', 1, 'sidebar-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(58, 110, 'Sidebar B', '', '<p class="uk-margin-bottom">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam</p>', 2, 'sidebar-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(59, 111, 'Sidebar B', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore. Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt.</p>', 3, 'sidebar-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(61, 112, 'Footer Menu', '', '', 1, 'footer-menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"footermenu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(62, 113, 'Top A', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 14, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(63, 114, 'Top A', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 15, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(64, 115, 'Top A', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 16, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(65, 116, 'Top A', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 17, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(71, 122, 'Top B', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 10, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(72, 123, 'Top B', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 11, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(73, 124, 'Top B', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 12, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(80, 0, 'Multilanguage status', '', '', 1, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_multilangstatus', 3, 1, '{"layout":"_:default","moduleclass_sfx":"","cache":"0"}', 1, '*'),
(81, 0, 'Joomla Version', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_version', 3, 1, '{"format":"short","product":"1","layout":"_:default","moduleclass_sfx":"","cache":"0"}', 1, '*'),
(82, 0, 'Finder', '', '', 1, 'search', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_finder', 1, 1, '{"searchfilter":"","show_autosuggest":"1","show_advanced":"0","layout":"_:default","moduleclass_sfx":"","field_size":25,"alt_label":"","show_label":"1","label_pos":"top","show_button":"0","button_pos":"right","opensearch":"1","opensearch_title":""}', 0, '*'),
(94, 141, 'Offcanvas Menu', '', '', 2, 'offcanvas', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"mainmenu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(95, 142, 'Offcanvas', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 3, 'offcanvas', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(99, 146, 'UIkit Intro', '', '<div class="uk-align-center uk-text-center uk-width-1-1 uk-width-medium-2-3">\n  <img class="" src="images/yootheme/features_icon_uikit_large.svg" alt="Demo" title="Get UIkit" width="240" height="240">\n  \n  <h3 class="uk-h2">Built with UIkit</h3>\n  \n  <p>UIkit is a lightweight and modular front-end framework for developing fast and powerful web interfaces. It comes with a wide range of reusable and combinable components. All UIkit classes are namespaced, so they won''t interfere with other frameworks and extensions you might be using. Here''s an overview of the different UIkit components, which you can easily modify using the customizer.</p>\n  \n  <p><a class="uk-button uk-margin-top" href="http://www.getuikit.com" target="_blank">Visit Website</a></p>\n</div>', 7, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(102, 149, 'Logo small', '', '<img src="images/yootheme/demo/default/logo.svg" width="40" height="40" alt="Demo">', 1, 'logo-small', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(106, 163, 'Widgetkit Intro', '', '<div class="uk-align-center uk-text-center uk-width-1-1 uk-width-medium-2-3">\n  <img class="" src="images/yootheme/features_icon_widgetkit.svg" alt="Demo" width="200" height="200">\n  \n  <h1>Widgetkit</h1>\n  \n  <p>Widgetkit 2 is the next generation toolkit for WordPress and Joomla. It provides a simple and user-friendly way to enrich your website experience with grids, switchers, slideshows and much more.</p>\n  \n  <p><a class="uk-button uk-margin-top" href="http://yootheme.com/widgetkit" target="_blank">Visit Website</a></p>\n</div>', 8, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(107, 169, 'Features Split', '', '', 9, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"39\\",\\"name\\":\\"Features Split\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(128, 201, 'Our blog', '', '<p class="uk-text-large">Follow us on other social networks.</p>\n\n<ul class="uk-grid uk-grid-small uk-flex uk-flex-center">\n  <li><a href="#" class="uk-icon-button"><i class="uk-icon-twitter"></i></a></li>\n  <li><a href="#" class="uk-icon-button"><i class="uk-icon-linkedin"></i></a></li>\n  <li><a href="#" class="uk-icon-button"><i class="uk-icon-google-plus"></i></a></li>\n  <li><a href="#" class="uk-icon-button"><i class="uk-icon-flickr"></i></a></li>\n</ul>', 1, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(132, 205, 'Theme Features', '', '<p class="uk-text-large">This theme is built on the <a href="http://www.warp-framework.com">Warp framework</a>, a well-engineered theme framework for WordPress and Joomla, and utilizes all of its latest features. The user interface is powered by <a href="http://www.getuikit.com">UIkit</a>, a lightweight and modular front-end framework, which provides the theme''s styling. The theme also comes with a wide range of different <a href="index.php/theme-features/layouts">layouts and widget variations</a>.</p>\n\n<p>This theme is available for <img src="images/yootheme/features_icon_joomla.svg" width="25" height="21" alt="Joomla">Joomla and <img src="images/yootheme/features_icon_wordpress.svg" width="23" height="22" alt="Wordpress">WordPress including the same features on each system.</p>', 1, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(136, 215, 'Widgetkit Download', '', '<div class="uk-flex uk-flex-middle uk-flex-center uk-flex-wrap" data-uk-margin="{cls:''uk-margin-top''}">\n  <div>\n    <h2 class="uk-margin-remove">Get Widgetkit 2. The next generation tool set.</h2>\n  </div>\n  <div>\n    <a class="uk-button uk-button-large uk-margin-left uk-margin-right" href="http://www.yootheme.com/widgetkit" target="_blank">Download</a>\n  </div>\n</div>\n', 11, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(138, 217, 'Top C', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 4, 'top-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(139, 218, 'Top C', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 5, 'top-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(140, 219, 'Top C', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 6, 'top-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(141, 220, 'Bottom C', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 6, 'bottom-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(143, 222, 'Bottom C', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 7, 'bottom-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(144, 223, 'Bottom C', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 8, 'bottom-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(145, 224, 'Bottom C', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 9, 'bottom-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(155, 234, 'Home Header Slideshow', '', '', 1, 'header', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"91\\",\\"name\\":\\"Home Header Slideshow\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(184, 266, 'Our Address', '', '<h3 class="uk-margin-small-top">\n  Avanti Theme\n</h3>\n<p>\nSanctuary Hills, Commonwealth<br>\nPhone: 555 - Dont-call-this<br>\nMail: <a href="#">info@avanti</a>\n</p>\n<p>Office: 9am - 6pm</p>', 1, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(200, 283, 'Blog Slideset', '', '', 1, 'bottom-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"87\\",\\"name\\":\\"Blog Slideset\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(206, 289, 'Theme Styles', '', '<div class="uk-grid uk-grid-match uk-margin-large-bottom" data-uk-grid-margin data-uk-grid-match="{target:''.uk-panel''}">\n    <div class="uk-width-medium-1-3">\n        <div class="uk-panel">\n            <h2 class="uk-h6 uk-margin-remove">Six beautiful styles</h2>\n            <h3 class="uk-h1 uk-margin-small-top">Theme styles</h3>\n        </div>\n    </div>\n    <div class="uk-width-medium-2-3">\n        <div class="uk-panel">\n            <p>We provide lovingly crafted style variations to give you a glimpse of what is possible with this theme. The built-in theme customizer allows you to modify colors, fonts, sizes and much more without any CSS knowledge. Just choose your colors with the color picker and adjust the theme with only a few clicks. Click on one of the images to see the style.</p>\n        </div>\n    </div>\n</div>\n', 2, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(207, 290, 'Featured Technologies', '', '', 1, 'bottom-d', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 1, '{"widgetkit":"{\\"id\\":\\"16\\",\\"name\\":\\"Theme Features Technologies\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(211, 294, 'Search', '', '', 1, 'offcanvas', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 0, '{"label":"","width":"","text":"","button":"0","button_pos":"left","imagebutton":"0","button_text":"","opensearch":"1","opensearch_title":"","set_itemid":"261","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(213, 297, 'Social Icons', '', '<a href="index.php/company" class="uk-margin-small-right uk-icon-hover uk-icon-small uk-icon-twitter"></a>\n<a href="index.php/company" class="uk-margin-small-right uk-icon-hover uk-icon-small uk-icon-pinterest"></a>\n<a href="index.php/company" class="uk-margin-small-right uk-icon-hover uk-icon-small uk-icon-facebook"></a>\n<a href="index.php/company" class="uk-margin-small-right uk-icon-hover uk-icon-small uk-icon-instagram"></a>\n<a href="index.php/company" class="uk-margin-small-right uk-icon-hover uk-icon-small uk-icon-youtube-play"></a>', 1, 'more', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(214, 298, 'Footer Brand Home', '', '<p>\n  <img src="images/yootheme/demo/default/logo.svg" width="40" height="40" alt="Demo">\n</p>\n<p class="tm-brand">\n  Avanti theme\n</p>\n<p>\n  Sanctuary Hills, Commonwealth<br>\n  Office: 9am - 6pm\n</p>', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(215, 299, 'Footer Brand', '', '<a class="tm-brand uk-flex uk-flex-middle" href="index.php"><img src="images/yootheme/demo/default/logo.svg" width="40" height="40" alt="Demo" class="uk-margin-small-right"> <span>Avanti theme</span></a>', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(216, 300, 'Our Services & Special Fields', '', '', 5, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 1, '{"widgetkit":"{\\"id\\":\\"92\\",\\"name\\":\\"Home Services\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(217, 301, 'Home Caste Studies', '', '', 0, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"93\\",\\"name\\":\\"Home Case Studie\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(218, 302, 'Home Our Work', '', '<div class="uk-grid uk-grid-match uk-margin-large-bottom" data-uk-grid-margin data-uk-grid-match="{target:''.uk-panel''}" data-uk-scrollspy="{cls:''uk-animation-fade'', repeat: true}">\n    <div class="uk-width-medium-1-3">\n        <div class="uk-panel">\n            <h2 class="uk-h6 uk-margin-remove">Recent client projects</h2>\n            <h3 class="uk-h1 uk-margin-small-top">Our Work</h3>\n        </div>\n    </div>\n    <div class="uk-width-medium-2-3">\n        <div class="uk-panel">\n            <p>Maecenas fermentum bibendum elit ut lacinia. Ut vel libero porttitor nisl cursus tempus at vehicula ligula. Sed viverra sem quis tortor molestie tempor. Ut dignissim mi nec egestas viverra. Donec orci nisi, suscipit eu dolor at, ullamcorper feugiat mi.</p>\n        </div>\n    </div>\n</div>', 1, 'top-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(219, 303, 'Home Clients Gallery', '', '', 2, 'top-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"94\\",\\"name\\":\\"Home Clients Gallery\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(221, 305, 'Home Quote', '', '<div class="uk-width-medium-2-3" data-uk-scrollspy="{cls:''uk-animation-slide-bottom'', repeat: true}">\n    <h3 class="uk-h1"><i>Within a year<br class="uk-hidden-small"> our company''s popularity has risen by 60%.</i></h3>\n	<p class="uk-column-medium-1-2">Maecenas fermentum bibendum elit ut lacinia. Ut vel libero porttitor nisl cursus tempus at vehicula ligula. Sed viverra sem quis tortor molestie tempor. Ut dignissim mi nec egestas viverra ed sem quis tortor molestie tempor. Ut dignissim mi nec egestas viverra.</p>\n	<p>\n      <small class="uk-h6">Kyle Reese</small><br>\n      <span class="uk-text-primary">Human Resistance</span>\n	</p>\n</div>', 4, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(222, 306, 'Fresh from our blog', '', '', 1, 'bottom-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 1, '{"widgetkit":"{\\"id\\":\\"87\\",\\"name\\":\\"Home Blog Teaser\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(223, 328, 'Portfolio Slideshow', '', '', 1, 'header', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"95\\",\\"name\\":\\"Portfolio Slideshow\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(224, 329, 'Portfolio Projects 1', '', '', 0, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"96\\",\\"name\\":\\"Portfolio Projects 1\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(225, 330, 'Portfolio Projects 2', '', '', 7, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"97\\",\\"name\\":\\"Portfolio Projects 2\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(226, 331, 'Portfolio Projects 3', '', '', 1, 'top-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"98\\",\\"name\\":\\"Portfolio Projects 3\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(227, 332, 'Portfolio Gallery', '', '', 5, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"99\\",\\"name\\":\\"Portfolio Gallery\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(228, 333, 'Portfolio More Works', '', '<div class="uk-grid uk-grid-match uk-margin-large-bottom" data-uk-grid-margin data-uk-grid-match="{target:''.uk-panel''}">\n    <div class="uk-width-medium-1-3">\n        <div class="uk-panel">\n            <h2 class="uk-h6 uk-margin-remove">This is not the end</h2>\n            <h3 class="uk-h1 uk-margin-small-top">More Works</h3>\n        </div>\n    </div>\n    <div class="uk-width-medium-2-3">\n        <div class="uk-panel">\n            <p>Maecenas fermentum bibendum elit ut lacinia. Ut vel libero porttitor nisl cursus tempus at vehicula ligula. Sed viverra sem quis tortor molestie tempor. Ut dignissim mi nec egestas viverra. Donec orci nisi, suscipit eu dolor at, ullamcorper feugiat mi.</p>\n        </div>\n    </div>\n</div>', 3, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(229, 334, 'Gallery', '', '', 9, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"101\\",\\"name\\":\\"Gallery\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(231, 336, 'Gallery Intro', '', '<h1>\n  We are loving details,<br class="uk-hidden-small"> and deliver handmade masterpieces.\n</h1>\n<p class="uk-column-medium-1-2">Aliquam vivamus nibh lorem, lacinia ac metus proin leo tempor nam. Est rutrum sed, in vestibulum orci condimentum. Cras torquent, diam wisi, adipiscing elementum tincidunt dui. In dis massa erat vulputate ras torquent, diam wisi, adipiscing elementum tincidunt dui. In dis massa erat vulputate felis suscipit, class pellentesque molestie, integer non. At vel eros eros vel fermentum.</p>', 1, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(232, 337, 'Gallery Our Projects', '', '<div class="uk-grid uk-grid-match uk-margin-large-bottom" data-uk-grid-margin data-uk-grid-match="{target:''.uk-panel''}">\n    <div class="uk-width-medium-1-3">\n        <div class="uk-panel">\n            <h2 class="uk-h6 uk-margin-remove">What has been done so far</h2>\n            <h3 class="uk-h1 uk-margin-small-top">Our Projects</h3>\n        </div>\n    </div>\n    <div class="uk-width-medium-2-3">\n        <div class="uk-panel">\n            <p>Maecenas fermentum bibendum elit ut lacinia. Ut vel libero porttitor nisl cursus tempus at vehicula ligula. Sed viverra sem quis tortor molestie tempor. Ut dignissim mi nec egestas viverra. Donec orci nisi, suscipit eu dolor at, ullamcorper feugiat mi.</p>\n        </div>\n    </div>\n</div>', 8, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(233, 338, 'Our Clients', '', '', 7, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 1, '{"widgetkit":"{\\"id\\":\\"103\\",\\"name\\":\\"Gallery Clients\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(235, 340, 'Our Special Fields', '', '', 6, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"104\\",\\"name\\":\\"Services Special Fields\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(236, 341, 'Our Services', '', '<h1>\n  Before Art comes Consulting.\n</h1>', 1, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(237, 342, 'Advertisment done right.', '', '', 1, 'top-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 1, '{"widgetkit":"{\\"id\\":\\"105\\",\\"name\\":\\"Services Advertisement\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(238, 343, 'Services Happy Clients', '', '<div class="uk-grid uk-grid-match uk-margin-large-bottom" data-uk-grid-margin data-uk-grid-match="{target:''.uk-panel''}">\n    <div class="uk-width-medium-1-3">\n        <div class="uk-panel">\n            <h2 class="uk-h6 uk-margin-remove">Well known clients</h2>\n            <h3 class="uk-h1 uk-margin-small-top">Happy Clients</h3>\n        </div>\n    </div>\n    <div class="uk-width-medium-2-3">\n        <div class="uk-panel">\n            <p>Maecenas fermentum bibendum elit ut lacinia. Ut vel libero porttitor nisl cursus tempus at vehicula ligula. Sed viverra sem quis tortor molestie tempor. Ut dignissim mi nec egestas viverra. Donec orci nisi, suscipit eu dolor at, ullamcorper feugiat mi.</p>\n        </div>\n    </div>\n</div>', 6, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(239, 344, 'Services Clients', '', '', 10, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"103\\",\\"name\\":\\"Gallery Clients\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(240, 345, 'Services Info', '', '', 3, 'bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"106\\",\\"name\\":\\"Services Infos\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(241, 346, 'Services Testimonials', '', '', 1, 'bottom-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"107\\",\\"name\\":\\"Services Testimonials\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(242, 347, 'About Our Company', '', '<h1>\n  Communication comes first.\n</h1>', 1, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(243, 348, 'Our Office', '', '<h1>\n  Everyday is a creative day\n</h1>\n<p>\n  In ac diam ullamcorper porttitor iaculis id, commodo wisi ligula vivamus lobortis ut, lorem pharetra amet luctus per, erat eget lacus tortor id, ac lacus. Lobortis sed condimentum posuere ac praesent, montes arcu sed pellentesque mi rutrum, dolor fringilla mus.\n</p>\n<p>\n  Eget nunc morbi aliquam ac, amet lobortis vivamus consectetuer a cubilia, nulla purus nunc cras vulputate tempor, fringilla mauris id cursus facilisis. Sem nam sollicitudin nulla lectus lectus mattis. \n</p>', 1, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(244, 349, 'Company Gallery', '', '', 4, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"108\\",\\"name\\":\\"Company Gallery\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(245, 350, 'Do you like to join us?', '', '<h1>\n  Current open jobs\n</h1>\n<p>\n  If you like to join us, please send a mail with your curriculum vitae to <a href="#">jobs@avanti</a> and we will contact you within 3 working days. If you want to apply for a graphic / engineering job please attach your current portfolio or something similiar.\n</p>', 7, 'top-d', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(246, 351, 'Company Jobs', '', '', 8, 'top-d', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"109\\",\\"name\\":\\"Company Jobs\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(248, 353, 'The leading chiefs', '', '', 0, 'top-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 1, '{"widgetkit":"{\\"id\\":\\"110\\",\\"name\\":\\"Company Leading Team\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(249, 354, 'The creative warriors', '', '', 1, 'top-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 1, '{"widgetkit":"{\\"id\\":\\"111\\",\\"name\\":\\"Company Creative Team\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(250, 357, 'Single Page Info', '', '<h6 class="uk-margin-bottom-remove">Client</h6>\n<p class="uk-margin-remove">Avanti Theme</p>\n<h6 class="uk-margin-bottom-remove">Branch</h6>\n<p class="uk-margin-remove">Theme for Joomla and WordPress</p>\n<h6 class="uk-margin-bottom-remove">Date</h6>\n<p class="uk-margin-remove">January 2016</p>\n', 1, 'sidebar-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(251, 358, 'Single Slideshow', '', '', 1, 'top-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"112\\",\\"name\\":\\"Single Slideshow\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*');
INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(252, 359, 'Single Page More Projects Headline', '', '<h2 class="uk-h6 uk-margin-remove">Must see</h2>\n<h3 class="uk-h1 uk-margin-small-top">More Projects</h3>', 8, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(253, 360, 'Single Page More Projects Widget', '', '', 9, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"113\\",\\"name\\":\\"Single Page More Projects\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(254, 361, 'Bottom A', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.', 12, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(255, 362, 'Bottom D', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.', 10, 'bottom-d', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(256, 363, 'Bottom D', '', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.', 1, 'bottom-d', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(257, 364, 'Top D', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 14, 'top-d', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(258, 365, 'Top D', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 1, 'top-d', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(259, 366, 'Top D', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 1, 'top-d', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(260, 367, 'Top D', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore.</p>', 1, 'top-d', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(261, 368, 'Theme Styles Grid', '', '', 3, 'top-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"55\\",\\"name\\":\\"Theme Features Styles\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(262, 369, 'Theme Widgets Headline', '', '<div class="uk-grid uk-grid-match uk-margin-large-bottom" data-uk-grid-margin data-uk-grid-match="{target:''.uk-panel''}">\n    <div class="uk-width-medium-1-3">\n        <div class="uk-panel">\n            <h2 class="uk-h6 uk-margin-remove">Custom widgets</h2>\n            <h3 class="uk-h1 uk-margin-small-top">Theme Widgets</h3>\n        </div>\n    </div>\n    <div class="uk-width-medium-2-3">\n        <div class="uk-panel">\n            <p>Avanti comes with some exclusive widgets which slightly differ from regular Widgetkit widgets. We have added some custom markup and new features.</p>\n        </div>\n    </div>\n</div>\n', 1, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(263, 370, 'Theme Widgets', '', '', 2, 'bottom-a', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"114\\",\\"name\\":\\"Theme Widgets\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(264, 371, 'Theme Additions Headline', '', '<div class="uk-grid uk-grid-match uk-margin-large-bottom" data-uk-grid-margin data-uk-grid-match="{target:''.uk-panel''}">\n    <div class="uk-width-medium-1-3">\n        <div class="uk-panel">\n            <h2 class="uk-h6 uk-margin-remove">CSS modifiers and additions</h2>\n            <h3 class="uk-h1 uk-margin-small-top">Theme Additions</h3>\n        </div>\n    </div>\n    <div class="uk-width-medium-2-3">\n        <div class="uk-panel">\n            <p>Avanti has some helper classes and modifiers to slightly upgrade and control the content display. You can use them to to modify your content. Just remove them, if you prefer the regular UIKit rendering.</p>\n        </div>\n    </div>\n</div>', 1, 'bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(265, 372, 'Theme Additions', '', '', 4, 'bottom-b', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_widgetkit', 1, 0, '{"widgetkit":"{\\"id\\":\\"89\\",\\"name\\":\\"Theme Features Additions\\"}","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(266, 373, 'Theme Icons', '', '<p class="uk-text-large">\n  We have added a custom webfont which contains some usefull icons which we also used in our Avanti UIkit theme.\n</p>\n<h4 class="uk-h5">How to use</h4>\n<p>\n    The theme icons are similiar to UIkit icon component. To apply this component, add any <span class="uk-text-primary">.uk-theme-icon-*</span> class to an <code>&lt;i&gt;</code> or <code>&lt;span&gt;</code> element. Et voilà, you have a vector icon, which inherits size and color just like your text does.\n</p>\n\n<ul class="uk-grid uk-grid-width-1-2 uk-grid-width-medium-1-4" data-uk-margin>\n    <li><i class="uk-icon-justify uk-theme-icon-slider-left"></i> slider-left</li>\n    <li><i class="uk-icon-justify uk-theme-icon-slider-right"></i> slider-right</li>\n    <li><i class="uk-icon-justify uk-theme-icon-slider-top"></i> slider-top</li>\n    <li><i class="uk-icon-justify uk-theme-icon-more"></i> more</li>\n    <li><i class="uk-icon-justify uk-theme-icon-search"></i> search</li>\n    <li><i class="uk-icon-justify uk-theme-icon-author"></i> author</li>\n    <li><i class="uk-icon-justify uk-theme-icon-comment"></i> comment</li>\n    <li><i class="uk-icon-justify uk-theme-icon-tag"></i> tag</li>\n    <li><i class="uk-icon-justify uk-theme-icon-arrow-left"></i> arrow-left</li>\n    <li><i class="uk-icon-justify uk-theme-icon-arrow-right"></i> arrow-right</li>\n    <li><i class="uk-icon-justify uk-theme-icon-arrow-up"></i> arrow-up</li>\n    <li><i class="uk-icon-justify uk-theme-icon-arrow-down"></i> arrow-down</li>\n    <li><i class="uk-icon-justify uk-theme-icon-plus"></i> plus</li>\n    <li><i class="uk-icon-justify uk-theme-icon-minus"></i> minus</li>\n    <li><i class="uk-icon-justify uk-theme-icon-check"></i> check</li>\n    <li><i class="uk-icon-justify uk-theme-icon-cross"></i> cross</li>\n    <li><i class="uk-icon-justify uk-theme-icon-menu"></i> menu</li>\n</ul>\n', 1, 'bottom-c', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*');

-- --------------------------------------------------------
DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0'
)  DEFAULT CHARSET=utf8;

--
-- Daten für Tabelle `#__modules_menu`
--

INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES
(1, 0),
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(17, 103),
(17, 108),
(17, 111),
(17, 112),
(17, 113),
(17, 114),
(17, 115),
(17, 116),
(17, 117),
(17, 118),
(17, 119),
(17, 120),
(17, 121),
(17, 122),
(17, 123),
(17, 214),
(17, 236),
(17, 244),
(17, 269),
(19, 103),
(20, 103),
(21, 103),
(27, 103),
(28, 103),
(29, 103),
(30, 103),
(34, 103),
(35, 103),
(36, 103),
(37, 103),
(38, 0),
(40, 0),
(42, 103),
(42, 108),
(42, 109),
(42, 110),
(42, 111),
(42, 112),
(42, 113),
(42, 114),
(42, 115),
(42, 116),
(42, 117),
(42, 118),
(42, 119),
(42, 120),
(42, 121),
(42, 122),
(42, 123),
(43, 103),
(44, 103),
(57, 103),
(58, 103),
(59, 103),
(61, 0),
(62, 103),
(63, 103),
(64, 103),
(65, 103),
(71, 103),
(72, 103),
(73, 103),
(80, 0),
(81, 0),
(82, 0),
(94, 0),
(95, 103),
(95, 109),
(99, 104),
(102, 0),
(106, 210),
(107, 215),
(128, 236),
(128, 244),
(132, 108),
(132, 241),
(136, 210),
(138, 103),
(139, 103),
(140, 103),
(141, 103),
(143, 103),
(144, 103),
(145, 103),
(155, 189),
(184, 258),
(200, 108),
(200, 214),
(200, 236),
(200, 244),
(206, 110),
(206, 241),
(207, 110),
(207, 241),
(211, 0),
(213, 0),
(214, 189),
(215, 103),
(215, 104),
(215, 108),
(215, 110),
(215, 111),
(215, 112),
(215, 113),
(215, 114),
(215, 115),
(215, 116),
(215, 117),
(215, 118),
(215, 119),
(215, 120),
(215, 121),
(215, 122),
(215, 123),
(215, 210),
(215, 211),
(215, 214),
(215, 217),
(215, 236),
(215, 241),
(215, 244),
(215, 256),
(215, 257),
(215, 258),
(215, 261),
(215, 263),
(215, 264),
(215, 265),
(215, 269),
(216, 189),
(217, 189),
(218, 189),
(219, 189),
(221, 189),
(221, 264),
(222, 189),
(223, 256),
(224, 256),
(225, 256),
(226, 256),
(227, 256),
(228, 256),
(229, 217),
(231, 217),
(232, 217),
(233, 217),
(235, 257),
(236, 257),
(237, 257),
(238, 257),
(239, 257),
(240, 257),
(241, 257),
(242, 258),
(243, 258),
(244, 258),
(245, 258),
(246, 258),
(248, 258),
(249, 258),
(250, 269),
(251, 269),
(252, 269),
(253, 269),
(254, 103),
(255, 103),
(256, 103),
(257, 103),
(258, 103),
(259, 103),
(260, 103),
(261, 241),
(262, 241),
(263, 241),
(264, 241),
(265, 241),
(266, 241);

-- --------------------------------------------------------
DROP TABLE IF EXISTS `#__tags`;
CREATE TABLE `#__tags` (
`id` int(10) unsigned NOT NULL,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
)  AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

--
-- Daten für Tabelle `#__tags`
--

INSERT INTO `#__tags` (`id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `created_by_alias`, `modified_user_id`, `modified_time`, `images`, `urls`, `hits`, `language`, `version`, `publish_up`, `publish_down`) VALUES
(1, 0, 0, 53, 0, '', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '', 322, '2011-01-01 00:00:01', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(2, 1, 1, 2, 1, 'cck', 'CCK', 'cck', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '{"author":"","robots":"","tags":null}', 322, '2013-05-12 13:19:42', '', 42, '2013-05-12 13:21:50', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(3, 1, 3, 4, 1, 'cms', 'CMS', 'cms', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '{"author":"","robots":"","tags":null}', 322, '2013-05-12 13:19:48', '', 42, '2013-05-12 13:21:57', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(4, 1, 5, 6, 1, 'content-application-builder', 'Content Application Builder', 'content-application-builder', '', '', -2, 0, '0000-00-00 00:00:00', 1, '', '', '', '{"author":"","robots":"","tags":null}', 322, '2013-05-12 13:19:57', '', 42, '2013-05-12 13:22:08', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(5, 1, 7, 8, 1, 'css', 'CSS', 'css', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '{"author":"","robots":"","tags":null}', 322, '2013-05-12 13:20:16', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(6, 1, 9, 10, 1, 'design', 'Design', 'design', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '{"author":"","robots":"","tags":null}', 322, '2013-05-12 13:20:22', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(7, 1, 11, 12, 1, 'framework', 'Framework', 'framework', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '{"author":"","robots":"","tags":null}', 322, '2013-05-12 13:20:28', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(8, 1, 13, 14, 1, 'icon', 'Icon', 'icon', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '{"author":"","robots":"","tags":null}', 322, '2013-05-12 13:20:43', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(9, 1, 15, 16, 1, 'icons', 'Icons', 'icons', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '{"author":"","robots":"","tags":null}', 322, '2013-05-12 13:20:46', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(10, 1, 17, 18, 1, 'illustrations', 'Illustrations', 'illustrations', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '{"author":"","robots":"","tags":null}', 322, '2013-05-12 13:20:54', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(11, 1, 19, 20, 1, 'joomla', 'Joomla', 'joomla', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '{"author":"","robots":"","tags":null}', 322, '2013-05-12 13:20:59', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(12, 1, 21, 22, 1, 'js', 'JavaScript', 'js', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '{"author":"","robots":"","tags":null}', 322, '2013-05-12 13:21:04', '', 42, '2013-05-12 13:25:27', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(13, 1, 23, 24, 1, 'php', 'PHP', 'php', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '{"author":"","robots":"","tags":null}', 322, '2013-05-12 13:21:09', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(14, 1, 25, 26, 1, 'theme', 'Theme', 'theme', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '{"author":"","robots":"","tags":null}', 322, '2013-05-12 13:21:19', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(15, 1, 27, 28, 1, 'themes', 'Themes', 'themes', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '{"author":"","robots":"","tags":null}', 322, '2013-05-12 13:21:23', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(16, 1, 29, 30, 1, 'web-design', 'Web Design', 'web-design', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '{"author":"","robots":"","tags":null}', 322, '2013-05-12 13:21:30', '', 42, '2013-05-12 13:22:19', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(17, 1, 31, 32, 1, 'wordpress', 'Wordpress', 'wordpress', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '{"author":"","robots":"","tags":null}', 322, '2013-05-12 13:21:36', '', 0, '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(18, 1, 33, 34, 1, 'news', 'News,', 'news', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{}', ' ', ' ', '{}', 322, '2015-12-04 10:38:02', '', 0, '2015-12-04 10:38:02', '{}', '{}', 0, '*', 1, '2015-12-04 10:38:02', '2015-12-04 10:38:02'),
(19, 1, 35, 36, 1, 'company', 'Company', 'company', '', '', 1, 0, '2015-12-04 10:38:02', 1, '{}', ' ', ' ', '{}', 322, '2015-12-04 10:38:02', '', 0, '2015-12-04 10:38:02', '{}', '{}', 0, '*', 1, '2015-12-04 10:38:02', '2015-12-04 10:38:02'),
(20, 1, 37, 38, 1, 'advertising', 'Advertising', 'advertising', '', '', 1, 0, '2015-12-04 10:38:25', 1, '{}', ' ', ' ', '{}', 322, '2015-12-04 10:38:25', '', 0, '2015-12-04 10:38:25', '{}', '{}', 0, '*', 1, '2015-12-04 10:38:25', '2015-12-04 10:38:25'),
(21, 1, 39, 40, 1, 'marketing', 'Marketing', 'marketing', '', '', 1, 0, '2015-12-04 10:38:25', 1, '{}', ' ', ' ', '{}', 322, '2015-12-04 10:38:25', '', 0, '2015-12-04 10:38:25', '{}', '{}', 0, '*', 1, '2015-12-04 10:38:25', '2015-12-04 10:38:25'),
(22, 1, 41, 42, 1, 'faq', 'FAQ', 'faq', '', '', 1, 0, '2015-12-04 10:39:35', 1, '{}', ' ', ' ', '{}', 322, '2015-12-04 10:39:35', '', 0, '2015-12-04 10:39:35', '{}', '{}', 0, '*', 1, '2015-12-04 10:39:35', '2015-12-04 10:39:35'),
(23, 1, 43, 44, 1, 'features', 'Features', 'features', '', '', 1, 0, '2015-12-04 10:39:35', 1, '{}', ' ', ' ', '{}', 322, '2015-12-04 10:39:35', '', 0, '2015-12-04 10:39:35', '{}', '{}', 0, '*', 1, '2015-12-04 10:39:35', '2015-12-04 10:39:35'),
(24, 1, 45, 46, 1, 'extension', 'Extension', 'extension', '', '', 1, 0, '2015-12-04 10:39:58', 1, '{}', ' ', ' ', '{}', 322, '2015-12-04 10:39:58', '', 0, '2015-12-04 10:39:58', '{}', '{}', 0, '*', 1, '2015-12-04 10:39:58', '2015-12-04 10:39:58'),
(25, 1, 47, 48, 1, 'widgets', 'Widgets', 'widgets', '', '', 1, 0, '2015-12-04 10:40:24', 1, '{}', ' ', ' ', '{}', 322, '2015-12-04 10:40:24', '', 0, '2015-12-04 10:40:24', '{}', '{}', 0, '*', 1, '2015-12-04 10:40:24', '2015-12-04 10:40:24'),
(26, 1, 49, 50, 1, 'branding', 'Branding', 'branding', '', '', 1, 0, '2015-12-10 08:54:18', 1, '{}', ' ', ' ', '{}', 322, '2015-12-10 08:54:18', '', 0, '2015-12-10 08:54:18', '{}', '{}', 0, '*', 1, '2015-12-10 08:54:18', '2015-12-10 08:54:18'),
(27, 1, 51, 52, 1, 'online-shop', 'Online Shop', 'online-shop', '', '', 1, 0, '2015-12-10 08:54:18', 1, '{}', ' ', ' ', '{}', 322, '2015-12-10 08:54:18', '', 0, '2015-12-10 08:54:18', '{}', '{}', 0, '*', 1, '2015-12-10 08:54:18', '2015-12-10 08:54:18');

-- --------------------------------------------------------
DROP TABLE IF EXISTS `#__template_styles`;
CREATE TABLE `#__template_styles` (
`id` int(10) unsigned NOT NULL,
  `template` varchar(50) NOT NULL DEFAULT '',
  `client_id` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `home` char(7) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `params` text NOT NULL
)  AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

--
-- Daten für Tabelle `#__template_styles`
--

INSERT INTO `#__template_styles` (`id`, `template`, `client_id`, `home`, `title`, `params`) VALUES
(3, 'atomic', 0, '0', 'Atomic - Default', '{}'),
(4, 'beez_20', 0, '0', 'Beez2 - Default', '{"wrapperSmall":"53","wrapperLarge":"72","logo":"images\\/joomla_black.gif","sitetitle":"Joomla!","sitedescription":"Open Source Content Management","navposition":"left","templatecolor":"personal","html5":"0"}'),
(5, 'hathor', 1, '0', 'Hathor - Default', '{"showSiteName":"0","colourChoice":"","boldText":"0"}'),
(6, 'beez5', 0, '0', 'Beez5 - Default-Fruit Shop', '{"wrapperSmall":"53","wrapperLarge":"72","logo":"images\\/sampledata\\/fruitshop\\/fruits.gif","sitetitle":"Matuna Market ","sitedescription":"Fruit Shop Sample Site","navposition":"left","html5":"0"}'),
(7, 'yoo_avanti', 0, '1', 'yoo_avanti - Default', '{"config":""}'),
(8, 'protostar', 0, '0', 'protostar - Default', '{"templateColor":"","logoFile":"","googleFont":"1","googleFontName":"Open+Sans","fluidContainer":"0"}'),
(9, 'isis', 1, '1', 'isis - Default', '{"templateColor":"","logoFile":""}'),
(10, 'beez3', 0, '0', 'beez3 - Default', '{"wrapperSmall":53,"wrapperLarge":72,"logo":"","sitetitle":"","sitedescription":"","navposition":"center","bootstrap":"","templatecolor":"nature","headerImage":"","backgroundcolor":"#eee"}');

-- --------------------------------------------------------
DROP TABLE IF EXISTS `#__ucm_base`;
CREATE TABLE `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(10) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL
)  DEFAULT CHARSET=utf8;

--
-- Daten für Tabelle `#__ucm_base`
--

INSERT INTO `#__ucm_base` (`ucm_id`, `ucm_item_id`, `ucm_type_id`, `ucm_language_id`) VALUES
(1, 40, 1, 0),
(2, 39, 1, 0),
(3, 38, 1, 0),
(4, 49, 1, 0),
(5, 25, 1, 0),
(6, 8, 1, 0),
(7, 9, 1, 0),
(8, 10, 1, 0),
(9, 11, 1, 0),
(10, 23, 1, 0),
(11, 24, 1, 0),
(12, 26, 1, 0),
(13, 51, 1, 0),
(14, 52, 1, 0),
(15, 53, 1, 0),
(16, 54, 1, 0),
(17, 55, 1, 0),
(18, 56, 1, 0),
(19, 57, 1, 0),
(20, 58, 1, 0),
(21, 59, 1, 0),
(22, 60, 1, 0);

-- --------------------------------------------------------
DROP TABLE IF EXISTS `#__ucm_content`;
CREATE TABLE `#__ucm_content` (
`core_content_id` int(10) unsigned NOT NULL,
  `core_type_alias` varchar(255) NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(255) NOT NULL,
  `core_alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `core_body` mediumtext NOT NULL,
  `core_state` tinyint(1) NOT NULL DEFAULT '0',
  `core_checked_out_time` varchar(255) NOT NULL DEFAULT '',
  `core_checked_out_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_access` int(10) unsigned NOT NULL DEFAULT '0',
  `core_params` text NOT NULL,
  `core_featured` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `core_metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_language` char(7) NOT NULL,
  `core_publish_up` datetime NOT NULL,
  `core_publish_down` datetime NOT NULL,
  `core_content_item_id` int(10) unsigned DEFAULT NULL COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned DEFAULT NULL COMMENT 'FK to the #__assets table.',
  `core_images` text NOT NULL,
  `core_urls` text NOT NULL,
  `core_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `core_version` int(10) unsigned NOT NULL DEFAULT '1',
  `core_ordering` int(11) NOT NULL DEFAULT '0',
  `core_metakey` text NOT NULL,
  `core_metadesc` text NOT NULL,
  `core_catid` int(10) unsigned NOT NULL DEFAULT '0',
  `core_xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int(10) unsigned DEFAULT NULL
)  AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COMMENT='Contains core content data in name spaced fields';

--
-- Daten für Tabelle `#__ucm_content`
--

INSERT INTO `#__ucm_content` (`core_content_id`, `core_type_alias`, `core_title`, `core_alias`, `core_body`, `core_state`, `core_checked_out_time`, `core_checked_out_user_id`, `core_access`, `core_params`, `core_featured`, `core_metadata`, `core_created_user_id`, `core_created_by_alias`, `core_created_time`, `core_modified_user_id`, `core_modified_time`, `core_language`, `core_publish_up`, `core_publish_down`, `core_content_item_id`, `asset_id`, `core_images`, `core_urls`, `core_hits`, `core_version`, `core_ordering`, `core_metakey`, `core_metadesc`, `core_catid`, `core_xreference`, `core_type_id`) VALUES
(1, 'com_content.article', 'Avanti Theme', 'avanti-theme-2', '<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. </p>\n\n', -2, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2015-04-15 15:02:02', 322, '2015-12-07 09:15:08', '*', '2015-04-15 15:02:02', '0000-00-00 00:00:00', 40, 65, '{"image_intro":"images\\/yootheme\\/blog_dynamic-09.jpg","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog_dynamic-09.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 41, 31, 1, '', '', 10, '', 1),
(2, 'com_content.article', 'Mini snacks', 'mini-snacks', '<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. </p>\n\n', -2, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2015-04-15 14:54:25', 322, '2015-12-07 10:18:49', '*', '2015-04-15 14:54:25', '0000-00-00 00:00:00', 39, 66, '{"image_intro":"images\\/yootheme\\/blog_dynamic-08.jpg","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog_dynamic-08.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 45, 26, 2, '', '', 10, '', 1),
(3, 'com_content.article', 'Fresh pancakes', 'fresh-pancakes', '<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. </p>\n\n', -2, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2015-04-15 14:52:46', 322, '2015-12-02 13:32:12', '*', '2015-04-15 14:52:46', '0000-00-00 00:00:00', 38, 67, '{"image_intro":"images\\/yootheme\\/blog_dynamic-07.jpg","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog_dynamic-07.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 7, 18, 3, '', '', 10, '', 1),
(4, 'com_content.article', 'Avanti Theme is here', 'avanti-theme', '<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p>\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-04-18 14:50:55', 322, '2015-12-07 16:51:34', '*', '2014-04-18 14:50:55', '0000-00-00 00:00:00', 49, 68, '{"image_intro":"images\\/yootheme\\/blog-01.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-01.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 44, 22, 0, '', '', 7, '', 1),
(5, 'com_content.article', 'Pagekit CMS', 'pagekit', '<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-03-28 15:50:55', 322, '2015-12-07 16:51:00', '*', '2014-03-28 15:50:55', '0000-00-00 00:00:00', 25, 69, '{"image_intro":"images\\/yootheme\\/blog-03.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-03.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 15, 40, 2, '', '', 7, '', 1),
(6, 'com_content.article', 'Joomla Templates', 'joomla-templates', '<p class="uk-text-large">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p class="uk-column-large-1-2">\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-04-02 11:50:02', 322, '2015-12-07 16:57:12', '*', '2014-04-02 11:50:02', '0000-00-00 00:00:00', 8, 70, '{"image_intro":"images\\/yootheme\\/blog-02.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-02.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 174, 86, 1, '', '', 7, '', 1),
(7, 'com_content.article', 'Beautiful Icons', 'beautiful-icons', '<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p>\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-03-15 11:50:30', 322, '2015-12-07 16:50:02', '*', '2014-03-15 11:50:30', '0000-00-00 00:00:00', 9, 152, '{"image_intro":"images\\/yootheme\\/blog-08.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-08.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 27, 31, 4, '', '', 7, '', 1),
(8, 'com_content.article', 'Warp Framework', 'warp-framework', '<p class="uk-text-large">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p class="uk-column-large-1-2">\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-03-12 11:50:55', 322, '2015-12-07 16:52:25', '*', '2014-03-12 11:50:55', '0000-00-00 00:00:00', 10, 154, '{"image_intro":"images\\/yootheme\\/blog-07.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-07.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 27, 36, 5, '', '', 7, '', 1),
(9, 'com_content.article', 'ZOO Extension', 'zoo-extension', '<blockquote>\n    <p>„Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.“</p>\n    <p><small>- Someone famous -</small></p>\n</blockquote>\n\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-02-28 11:51:30', 322, '2015-12-07 16:51:14', '*', '2014-02-28 11:51:30', '0000-00-00 00:00:00', 11, 157, '{"image_intro":"images\\/yootheme\\/blog-06.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-06.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 12, 29, 6, '', '', 7, '', 1),
(10, 'com_content.article', 'Widgetkit', 'widgetkit-extension', '<p class="uk-article-lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n<p>\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-02-14 11:50:55', 322, '2015-12-07 16:51:40', '*', '2014-02-14 11:50:55', '0000-00-00 00:00:00', 23, 307, '{"image_intro":"images\\/yootheme\\/blog-05.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-05.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 10, 31, 7, '', '', 7, '', 1),
(11, 'com_content.article', 'UIkit Framework', 'uikit', '<p class="uk-column-xlarge-1-4 uk-column-large-1-3 uk-column-medium-1-2">\n  Placerat dolor, lacus euismod amet vitae ac, sodales libero amet viverra leo sagittis et. Vel augue sem elit tristique tempor, nullam lectus, ullamcorper tellus lobortis a risus, feugiat felis vel aliquam quam nullam adipiscing. Erat tincidunt dis quis mi ut, vestibulum odio purus arcu tincidunt dignissim sapien, dolor viverra orci wisi augue, pede lobortis ipsum. Lorem a, nulla non justo arcu non sodales, turpis convallis sed fusce purus natus quisque. Nunc aliquam orci luctus ligula ullamcorper fringilla, cras sit pellentesque sed est, lectus pretium, libero ut libero mattis massa est ultricies.\n</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-03-22 11:50:55', 322, '2015-12-07 16:56:57', '*', '2014-03-22 11:50:55', '0000-00-00 00:00:00', 24, 308, '{"image_intro":"images\\/yootheme\\/blog-04.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-04.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 13, 40, 3, '', '', 7, '', 1),
(12, 'com_content.article', 'Free Halloween Icons', 'free-halloween-icons', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-01-18 14:50:55', 322, '2015-12-07 16:50:54', '*', '2014-01-18 14:50:55', '0000-00-00 00:00:00', 26, 309, '{"image_intro":"images\\/yootheme\\/blog-09.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-09.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 13, 39, 8, '', '', 7, '', 1),
(13, 'com_content.article', 'Avanti Theme is here', 'avanti-theme-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-04-18 14:50:55', 322, '2015-12-14 14:37:33', '*', '2014-04-18 14:50:55', '0000-00-00 00:00:00', 51, 311, '{"image_intro":"images\\/yootheme\\/blog-dynamic-01.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-dynamic-01.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 0, 25, 0, '', '', 10, '', 1),
(14, 'com_content.article', 'Free Halloween Icons', 'free-halloween-icons-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-01-18 14:50:55', 322, '2015-12-14 14:37:39', '*', '2014-01-18 14:50:55', '0000-00-00 00:00:00', 52, 313, '{"image_intro":"images\\/yootheme\\/blog-dynamic-09.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-dynamic-09.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 0, 42, 8, '', '', 10, '', 1),
(15, 'com_content.article', 'Pagekit CMS', 'pagekit-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-03-28 15:50:55', 322, '2015-12-14 14:37:46', '*', '2014-03-28 15:50:55', '0000-00-00 00:00:00', 53, 315, '{"image_intro":"images\\/yootheme\\/blog-dynamic-03.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-dynamic-03.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 0, 43, 2, '', '', 10, '', 1),
(16, 'com_content.article', 'UIkit Framework', 'uikit-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-03-22 11:50:55', 322, '2015-12-14 14:37:53', '*', '2014-03-22 11:50:55', '0000-00-00 00:00:00', 54, 317, '{"image_intro":"images\\/yootheme\\/blog-dynamic-04.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-dynamic-04.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 0, 44, 3, '', '', 10, '', 1),
(17, 'com_content.article', 'Widgetkit', 'widgetkit-extension-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-02-14 11:50:55', 322, '2015-12-14 14:37:59', '*', '2014-02-14 11:50:55', '0000-00-00 00:00:00', 55, 319, '{"image_intro":"images\\/yootheme\\/blog-dynamic-05.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-dynamic-05.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 0, 34, 7, '', '', 10, '', 1),
(18, 'com_content.article', 'ZOO Extension', 'zoo-extension-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-02-28 11:51:30', 322, '2015-12-14 14:38:05', '*', '2014-02-28 11:51:30', '0000-00-00 00:00:00', 56, 321, '{"image_intro":"images\\/yootheme\\/blog-06.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-06.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 0, 31, 6, '', '', 10, '', 1),
(19, 'com_content.article', 'Warp Framework', 'warp-framework-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-03-12 11:50:55', 322, '2015-12-14 14:38:17', '*', '2014-03-12 11:50:55', '0000-00-00 00:00:00', 57, 323, '{"image_intro":"images\\/yootheme\\/blog-07.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-07.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 0, 38, 5, '', '', 10, '', 1),
(20, 'com_content.article', 'Beautiful Icons', 'beautiful-icons-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-03-15 11:50:30', 322, '2015-12-14 14:38:22', '*', '2014-03-15 11:50:30', '0000-00-00 00:00:00', 58, 325, '{"image_intro":"images\\/yootheme\\/blog-dynamic-08.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-dynamic-08.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 3, 36, 4, '', '', 10, '', 1),
(21, 'com_content.article', 'Joomla Templates', 'joomla-templates-2', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>\n\n', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2014-04-02 11:50:02', 322, '2015-12-15 10:36:04', '*', '2014-04-02 11:50:02', '0000-00-00 00:00:00', 59, 327, '{"image_intro":"images\\/yootheme\\/blog-dynamic-02.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/yootheme\\/blog-dynamic-02.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 2, 91, 1, '', '', 10, '', 1),
(22, 'com_content.article', 'Single Page Example', 'single-page', '<p>\n  Dictum lorem adipiscing augue vitae ante. Quis scelerisque sem urna pellentesque eu dolorum quisque ullamcorper. Pede nulla fringilla. Nec dolor purus elementum non mauris. Lacus aenean posuere.\n</p>\n\n<p>\n  Non a lacus. Arcu nunc vestibulum. Morbi reprehenderit nulla euismod quam adipiscing tempus amet suscipit leo fringilla amet nunc sit erat blandit aliquam urna. In fermentum vestibulum ut vulputate ultricies ac morbi vulputate et euismod erat. Sit enim erat. Nullam eu assumenda. Sit ante rhoncus donec vitae cras. Est ac ridiculus. Lacus justo volutpat. Felis dignissim at. Lectus adipiscing in. Eros eu felis.\n</p>', 1, '', 0, 1, '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 0, '{"robots":"","author":"","rights":"","xreference":""}', 322, '', '2015-12-10 08:54:18', 322, '2015-12-10 09:30:26', '*', '2015-12-10 08:54:18', '0000-00-00 00:00:00', 60, 356, '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', 11, 4, 0, '', '', 2, '', 1);

-- --------------------------------------------------------
DROP TABLE IF EXISTS `#__widgetkit`;
CREATE TABLE `#__widgetkit` (
`id` int(10) NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `data` longtext NOT NULL
)  AUTO_INCREMENT=116 DEFAULT CHARSET=utf8;

--
-- Daten für Tabelle `#__widgetkit`
--

INSERT INTO `#__widgetkit` (`id`, `name`, `type`, `data`) VALUES
(16, 'Theme Features Technologies', 'custom', '{"_widget":{"name":"grid","data":{"grid":"default","gutter":"default","gutter_dynamic":"20","gutter_v_dynamic":"","filter":"none","filter_align":"left","filter_all":true,"columns":"1","columns_small":0,"columns_medium":"2","columns_large":"2","columns_xlarge":"2","panel":"space","panel_link":false,"animation":"scale-up","media":true,"image_width":"auto","image_height":"auto","media_align":"top","media_width":"1-2","media_breakpoint":"medium","content_align":true,"media_border":"none","media_overlay":"none","overlay_animation":"fade","media_animation":"scale","title":true,"content":true,"social_buttons":true,"title_size":"panel","text_align":"center","link":true,"link_style":"button","link_text":"Read more","badge":true,"badge_style":"badge","badge_position":"panel","link_target":false,"class":""}},"items":[{"title":"UIkit Framework","media":"images\\/yootheme\\/features_icon_uikit.svg","width":"","content":"A lightweight and modular front-end framework for developing fast and powerful web interfaces.","link":"http:\\/\\/www.getuikit.com\\/","options":{"media":{"width":150,"height":150}}},{"title":"Warp Framework","media":"images\\/yootheme\\/features_icon_warp.svg","width":"","content":"A fast and slick theme framework which is built on the latest web techniques.","link":"http:\\/\\/www.warp-framework.com\\/","options":{"media":{"width":150,"height":150}}}],"_fields":[]}'),
(25, 'Widgetkit Features', 'custom', '{"_widget":{"name":"grid","data":{"grid":"default","gutter":"default","gutter_dynamic":"20","gutter_v_dynamic":"","filter":"none","filter_align":"left","filter_all":true,"columns":"1","columns_small":0,"columns_medium":"3","columns_large":"3","columns_xlarge":"3","panel":"blank","panel_link":false,"animation":"none","media":"0","image_width":"auto","image_height":"auto","media_align":"teaser","media_width":"1-2","media_breakpoint":"medium","content_align":true,"media_border":"none","media_overlay":"icon","overlay_animation":"fade","media_animation":"scale","title":"0","content":true,"social_buttons":true,"title_size":"panel","text_align":"left","link":true,"link_style":"button","link_text":"Read more","badge":true,"badge_style":"badge","badge_position":"panel","link_target":false,"class":""}},"items":[{"media":"","content":"<ul class=\\"uk-list uk-list-space\\">\\n    <li><i class=\\"uk-icon uk-icon-check\\"><\\/i> All widgets are fully responsive<\\/li>\\n    <li><i class=\\"uk-icon uk-icon-check\\"><\\/i> Use shortcodes to show widgets anywhere<\\/li>\\n<\\/ul>","title":"Features 1","options":{"media":[]}},{"media":"","title":"Features 2","content":"<ul class=\\"uk-list uk-list-space\\">\\n    <li><i class=\\"uk-icon uk-icon-check\\"><\\/i> Clean and lightweight code<\\/li>\\n    <li><i class=\\"uk-icon uk-icon-check\\"><\\/i> User friendly interface<\\/li>\\n<\\/ul>"},{"media":"","title":"Features 3","content":"<ul class=\\"uk-list uk-list-space\\">\\n    <li><i class=\\"uk-icon uk-icon-check\\"><\\/i> Supports touch gestures for mobile devices<\\/li>\\n    <li><i class=\\"uk-icon uk-icon-check\\"><\\/i> Built with the UIkit framework<\\/li>\\n<\\/ul>"}],"_fields":[]}'),
(26, 'Widgetkit Widgets', 'custom', '{"_widget":{"name":"grid","data":{"grid":"default","gutter":"default","gutter_dynamic":"20","gutter_v_dynamic":"","filter":"none","filter_align":"left","filter_all":true,"columns":"1","columns_small":"2","columns_medium":"4","columns_large":"4","columns_xlarge":"4","panel":"box","panel_link":false,"animation":"scale-up","media":true,"image_width":"auto","image_height":"auto","media_align":"top","media_width":"1-2","media_breakpoint":"medium","content_align":true,"media_border":"none","media_overlay":"none","overlay_animation":"fade","media_animation":"scale","title":true,"content":true,"social_buttons":true,"title_size":"h4","text_align":"center","link":true,"link_style":"button","link_text":"Read more","badge":true,"badge_style":"badge","badge_position":"panel","link_target":false,"class":""}},"items":[{"title":"Slideshow","media":"images\\/yootheme\\/widget_slideshow.svg","width":"","options":{"media":{"width":40,"height":40}}},{"title":"Grid","media":"images\\/yootheme\\/widget_grid.svg","width":"","options":{"media":{"width":40,"height":40}}},{"title":"Grid Stack","media":"images\\/yootheme\\/widget_grid-stack.svg","width":"","options":{"media":{"width":40,"height":40}}},{"title":"Switcher","media":"images\\/yootheme\\/widget_switcher.svg","width":"","options":{"media":{"width":40,"height":40}}},{"title":"Map","media":"images\\/yootheme\\/widget_map.svg","width":"","options":{"media":{"width":40,"height":40}}},{"title":"Accordion","media":"images\\/yootheme\\/widget_accordion.svg","width":"","options":{"media":{"width":40,"height":40}}},{"title":"Gallery","media":"images\\/yootheme\\/widget_gallery.svg","width":"","options":{"media":{"width":40,"height":40}}},{"title":"Grid Slider","media":"images\\/yootheme\\/widget_grid-slider.svg","width":"","options":{"media":{"width":40,"height":40}}},{"media":"images\\/yootheme\\/widget_slider.svg","options":{"media":{"width":null,"height":null}},"title":"Slider"},{"media":"images\\/yootheme\\/widget_parallax.svg","title":"Parallax","options":{"media":{"width":null,"height":null}}},{"media":"images\\/yootheme\\/widget_slideset.svg","title":"Slideset","options":{"media":{"width":40,"height":40}}},{"media":"images\\/yootheme\\/widget_list.svg","options":{"media":{"width":40,"height":40}},"title":"List"},{"media":"images\\/yootheme\\/widget_popover.svg","title":"Popover","options":{"media":{"width":40,"height":40}}},{"media":"images\\/yootheme\\/widget_switcher-panel.svg","title":"Switcher Panel","options":{"media":{"width":40,"height":40}}},{"media":"images\\/yootheme\\/widget_slideshow-panel.svg","title":"Slideshow Panel","options":{"media":{"width":40,"height":40}}}],"_fields":[]}'),
(28, 'Widgetkit Tutorial', 'custom', '{"_widget":{"name":"grid-stack","data":{"width":"1-2","align":"right","breakpoint":"medium","alternate":true,"gutter":true,"gutter_vertical":"default","divider":"1","panel":"0","content_align":true,"animation_media":"slide","animation_content":"slide","media":true,"image_width":"auto","image_height":"auto","media_border":"none","media_overlay":"none","overlay_animation":"fade","media_animation":"scale","title":true,"content":true,"social_buttons":true,"title_size":"h2","text_align":"left","link":true,"link_style":"button","link_text":"Read more","badge":true,"badge_style":"badge","badge_position":"panel","link_target":false,"class":""}},"items":[{"media":"images\\/yootheme\\/widgetkit2_create.png","options":{"media":{"width":700,"height":480}},"content":"<p>To get started, click on the <strong>Widgetkit<\\/strong> button in your CMS edit view. You will be directed to an overview of already existing widgets, hit the <strong>New<\\/strong> button. Now choose the widget you would like to render, for example <strong>Grid<\\/strong> and the content type. Afterwards hit <strong>Create<\\/strong> to proceed to the next step.<\\/p>","title":"Start in the editor"},{"media":"images\\/yootheme\\/widgetkit2_add.png","title":"Explore the Interface","options":{"media":{"width":700,"height":480}},"content":"<p>To create your content, you can add single content items by using <strong>Add Item<\\/strong>. Alternatively you can use <strong>Add Media<\\/strong> to select multiple items at once through the media library or manager of your CMS. Enter a name for your widget and go to the <strong>Settings<\\/strong> tab to configure your widget, then hit <strong>Save<\\/strong>.<\\/p>"},{"media":"images\\/yootheme\\/widgetkit2_insert.png","title":"Using the shortcodes","options":{"media":{"width":700,"height":480}},"content":"<p>After saving, hit the <strong>Cancel<\\/strong> button to get back to the widget overview. Click on your newly created widget and a shortcode containing the widget''s ID and name will be inserted in the editor. To edit the widget, click inside the shortcode and hit the Widgetkit button again.<\\/p>"}],"_fields":[]}'),
(54, 'Blog Grid Dynamic', 'joomla', '{"_widget":{"name":"grid_avanti","data":{"grid":"dynamic","gutter":"default","gutter_dynamic":"40","gutter_v_dynamic":"","filter":"none","filter_align":"left","filter_all":true,"columns":"1","columns_small":"2","columns_medium":"0","columns_large":"3","columns_xlarge":0,"divider":false,"panel":"blank","panel_link":false,"animation":"scale-up","media":true,"image_width":"auto","image_height":"auto","media_align":"teaser","media_width":"1-2","media_breakpoint":"medium","content_align":true,"media_border":"none","media_overlay":"link","overlay_animation":"fade","media_animation":"scale","title":true,"title_truncate":"","content":true,"content_truncate":"120","social_buttons":true,"title_size":"panel","text_align":"left","link":true,"link_style":"button-link","link_text":"Read more","badge":true,"badge_style":"badge","badge_position":"panel","link_target":false,"class":""}},"number":9,"category":["10"],"subcategories":0,"featured":1,"content":"intro","image":"intro","link":"","order_by":"rdate","author":"author","date":"publish_up"}'),
(55, 'Theme Features Styles', 'custom', '{"_widget":{"name":"gallery","data":{"grid":"default","gutter":"default","gutter_dynamic":"20","gutter_v_dynamic":"","filter":"none","filter_align":"left","filter_all":true,"columns":"1","columns_small":0,"columns_medium":"3","columns_large":"0","columns_xlarge":0,"animation":"none","image_width":"auto","image_height":"auto","media_border":"none","overlay":"center","panel":"hover","overlay_center":"icon","overlay_background":"hover","overlay_image":false,"hover_overlay":true,"overlay_animation":"fade","image_animation":"scale","title":true,"content":true,"title_size":"h4","link":false,"link_style":"button","link_icon":"share","link_text":"View","lightbox":false,"lightbox_caption":"content","lightbox_nav_width":"70","lightbox_nav_height":"70","lightbox_nav_contrast":true,"lightbox_title_size":"panel","lightbox_content_size":"","lightbox_content_width":"","lightbox_width":"auto","lightbox_height":"auto","lightbox_alt":false,"lightbox_link":false,"lightbox_style":"button","lightbox_icon":"search","lightbox_text":"Details","link_target":false,"class":"uk-text-center"}},"items":[{"media":"images\\/yootheme\\/features_style_01.jpg","options":{"media":{"width":960,"height":720}},"title":"Default","link":"index.php?option=com_content&view=article&id=6&Itemid=241&style=default","lightbox_content":""},{"media":"images\\/yootheme\\/features_style_02.jpg","options":{"media":{"width":960,"height":720}},"title":"Minimal","link":"index.php?option=com_content&view=article&id=6&Itemid=241&style=minimal","lightbox_content":""},{"media":"images\\/yootheme\\/features_style_03.jpg","options":{"media":{"width":960,"height":720}},"title":"Noble","link":"index.php?option=com_content&view=article&id=6&Itemid=241&style=noble","lightbox_content":""},{"media":"images\\/yootheme\\/features_style_04.jpg","options":{"media":{"width":960,"height":720}},"title":"Colorful","link":"index.php?option=com_content&view=article&id=6&Itemid=241&style=colorful","lightbox_content":""},{"media":"images\\/yootheme\\/features_style_05.jpg","options":{"media":{"width":960,"height":720}},"title":"Urban","link":"index.php?option=com_content&view=article&id=6&Itemid=241&style=urban","lightbox_content":""},{"media":"images\\/yootheme\\/features_style_06.jpg","options":{"media":{"width":960,"height":720}},"title":"Modern","link":"index.php?option=com_content&view=article&id=6&Itemid=241&style=modern","lightbox_content":""}],"_fields":[{"type":"textarea","name":"lightbox_content","label":"Lightbox Content"}]}'),
(56, 'Theme Features', 'custom', '{"_widget":{"name":"grid-stack","data":{"width":"1-2","align":"left","breakpoint":"medium","alternate":true,"gutter":true,"gutter_vertical":"default","divider":true,"panel":true,"content_align":true,"animation_media":"fade","animation_content":"fade","media":true,"image_width":"auto","image_height":"auto","media_border":"none","media_overlay":"none","overlay_animation":"fade","media_animation":"scale","title":true,"content":true,"social_buttons":true,"title_size":"h2","text_align":"left","link":true,"link_style":"button","link_text":"Read more","badge":true,"badge_style":"badge","badge_position":"panel","link_target":false,"class":""}},"items":[{"media":"images\\/yootheme\\/features_navbar.gif","options":{"media":{"width":960,"height":1090}},"title":"Navigation","content":"<p>The main navigation of Avanti Theme supports the latest UIkit sticky navigation component features. You are able to select from 3 different navigation behaviors\\/styles and 2 layouts. The styles and the layouts can be combined. This makes 6 different navigation combinations.<\\/p>\\n\\n<h4 class=\\"uk-h6\\">Navigation Styles<\\/h4>\\n<ul class=\\"uk-list uk-list-space\\">\\n<li><strong>Not Sticky<\\/strong> - Default navigation.<\\/li>\\n<li><strong>Always Sticky<\\/strong> - Floating sticky navigation with spacing around the navigation bar.<\\/li>\\n<li><strong>Sticky and Animated<\\/strong> - This style floats over the content and sticks to the top of the browser window when you start scrolling down.<\\/li>\\n<\\/ul>\\n\\n<h4 class=\\"uk-h6\\">Navigation Layouts<\\/h4>\\n<ul class=\\"uk-list uk-list-space\\">\\n<li><strong>Single Row<\\/strong> - The default navbar with the logo on the left side and centered menu items. <em>\\/layouts\\/header.default.php<\\/em><\\/li>\\n<li><strong>Centered<\\/strong> - Logo and menu items are centered and stacked. <em>\\/layouts\\/header.centered.php<\\/em><\\/li>\\n<\\/ul>\\n<p><small><em>If you want to support a bigger logo size or if you want to modify the navbar gutter, please use the Customizer to change the values.<\\/em><\\/small><\\/p>\\n\\n<h4 class=\\"uk-h6\\">Special navbar positions<\\/h4>\\n<ul class=\\"uk-list uk-list-space\\">\\n<li><strong>search<\\/strong> - The search will be displayed inside a dropdown with automatic focus on the search field.<\\/li>\\n<li><strong>more<\\/strong> - The same markup as the search, a dropdown which can be used for social icons for example.<\\/li>\\n<\\/ul>\\n<p><small><em>If you want to change the dropdown width or color, please use the Customizer to change the values.<\\/em><\\/small><\\/p>"},{"media":"images\\/yootheme\\/features_footer.gif","options":{"media":{"width":960,"height":720}},"title":"Footer","content":"<p>In this theme you can choose from 2 different footer layouts and combine them with the fixed footer option.<\\/p>\\n\\n<h4 class=\\"uk-h6\\">Footer Layouts<\\/h4>\\n<ul class=\\"uk-list uk-list-space\\">\\n<li><strong>Single Row<\\/strong> - The default footer with the footer module\\/widget on the left side and the footer-menu on the right. <em>\\/layouts\\/footer.default.php<\\/em><\\/li>\\n<li><strong>Centered<\\/strong> - Footer module\\/widget is centered and the footer-menu is centered below. <em>\\/layouts\\/footer.centered.php<\\/em><\\/li>\\n<\\/ul>\\n\\n<h4 class=\\"uk-h6\\">Options<\\/h4>\\n<p><strong>Footer Fixed:<\\/strong> This fixes the footer block position and your website will scroll over the footer.<br>\\n<strong>Enable Contrast<\\/strong>: This option toggles the uk-contrast class from UIkit. It improves the appearance of elements when placing them on colored or dark backgrounds.<\\/p>\\n<p><small><em>To modify the height of the footer and\\/or the fixed footer, please change the height values in the Customizer.<\\/em><\\/small><\\/p>"},{"media":"images\\/yootheme\\/features_block.gif","options":{"media":{"width":960,"height":1340}},"title":"Block Appearance","content":"<p>Avanti supports some useful options for all block layout positions. All settings can be combined for a block position. If you need different block settings for different pages, you can use <a href=\\"http:\\/\\/yootheme.com\\/themes\\/documentation\\/get-started\\/layouts\\" target=\\"_blank\\">layout profiles<\\/a> and assign them to your menu items.<\\/p>\\n\\n<h4 class=\\"uk-h6\\">Options<\\/h4>\\n<ul class=\\"uk-list uk-list-space\\">\\n<li><strong>Background<\\/strong> - Choose from 4 different background colors.<\\/li>\\n<li><strong>Image<\\/strong> - Enter a path to a background image for this position.<\\/li>\\n<li><strong>Image Blend<\\/strong> - Define how the background image will mix\\/blend with the background color.<\\/li>\\n<li><strong>Image Opacity<\\/strong> - Adds an overlay with the same background color of the block and an opacity value.<\\/li>\\n<li><strong>Contrast<\\/strong> - Enables the <a href=\\"http:\\/\\/getuikit.com\\/docs\\/contrast.html\\" target=\\"_blank\\">Contrast component<\\/a>. Recommended for block positions with a primary background color or image.<\\/li>\\n<li><strong>Padding<\\/strong> - Select the spacing between the content and its block container.<\\/li>\\n<li><strong>Full Width<\\/strong> - This removes the constraint of the content container so it will extend to full viewport width. Recommended for full width Widgetkit slideshows, for example.<\\/li>\\n<li><strong>Full Height<\\/strong> - The block will take up full viewport height. If the navbar is set to default, the navbar height will automatically be subtracted from the subsequent block.<\\/li>\\n<li><strong>Grid Collapse<\\/strong> - This option will reset the grid gutter and is recommended, if you want to use a full width Widgetkit slideshow or something similar.<\\/li>\\n<li><strong>Class<\\/strong> - Use this input field for a custom CSS class which will be added to the block.<\\/li>\\n<\\/ul>\\n<p><small><em>If you want to modify the background colors or paddings of the block elements, please use the Customizer and change the values.<\\/em><\\/small><\\/p>"},{"media":"images\\/yootheme\\/features_other.jpg","options":{"media":{"width":960,"height":720}},"title":"Other Options","content":"<p>Additionally you have more options to customize your theme layout.<\\/p>\\n\\n<h4 class=\\"uk-h6\\">Article Style<\\/h4>\\n<p>Display blog articles in a special theme specific layout. <em>\\/layouts\\/article.php<\\/em><\\/p>\\n\\n<h4 class=\\"uk-h6\\">Breadcrumb<\\/h4>\\n<p>This option centers the breadcrumbs and adds some more spacing to the following elements. Recommend for the theme specific article layout.<\\/p>"}],"_fields":[]}'),
(87, 'Home Blog Teaser', 'joomla', '{"_widget":{"name":"grid_avanti","data":{"grid":"default","gutter":"default","gutter_dynamic":"20","gutter_v_dynamic":"","filter":"none","filter_align":"left","filter_all":true,"columns":"1","columns_small":0,"columns_medium":"3","columns_large":0,"columns_xlarge":0,"divider":true,"panel":"space-horizontal","panel_link":false,"animation":"slide-top","media":false,"image_width":"auto","image_height":"auto","media_align":"teaser","media_width":"1-2","media_breakpoint":"medium","content_align":true,"media_border":"none","media_overlay":"icon","overlay_animation":"fade","media_animation":"scale","title":true,"title_truncate":"","content":true,"content_truncate":"90","social_buttons":true,"title_size":"panel","text_align":"left","link":true,"link_style":"button-link","link_text":"Read more","badge":true,"badge_style":"muted","badge_position":"panel","link_target":false,"class":""}},"items":[{"title":"Pasta","media":"images\\/yootheme\\/blog-01.jpg","width":"1000","height":"675","options":{"media":{"width":960,"height":640}},"content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit sed do eiusmod."},{"title":"Spices & Herbs","media":"images\\/yootheme\\/blog-02.jpg","width":"1000","height":"675","options":{"media":{"width":960,"height":640}},"content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit sed do eiusmod."},{"title":"Bacon Burger","media":"images\\/yootheme\\/blog-03.jpg","width":"1000","height":"675","options":{"media":{"width":960,"height":640}},"content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit sed do eiusmod."},{"title":"Grilled Chicken","media":"images\\/yootheme\\/blog-04.jpg","width":"1000","height":"675","options":{"media":{"width":960,"height":640}},"content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit sed do eiusmod."},{"title":"After Work","media":"images\\/yootheme\\/blog-05.jpg","width":"1000","height":"675","options":{"media":{"width":960,"height":640}},"content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit sed do eiusmod."},{"title":"Cheddar Bagle","media":"images\\/yootheme\\/blog-06.jpg","width":"1000","height":"675","options":{"media":{"width":960,"height":640}},"content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit sed do eiusmod."},{"title":"Tasty Breakfast","media":"images\\/yootheme\\/blog-07.jpg","width":"1000","height":"675","options":{"media":{"width":960,"height":640}},"content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit sed do eiusmod."},{"title":"Summer Snacks","media":"images\\/yootheme\\/blog-08.jpg","width":"1000","height":"675","options":{"media":{"width":960,"height":640}},"content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit sed do eiusmod."},{"title":"Asia Buffet","media":"images\\/yootheme\\/blog-09.jpg","width":"1000","height":"675","options":{"media":{"width":960,"height":640}},"content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit sed do eiusmod."}],"_fields":[{"name":"tags","type":"tags","label":"Tags","core":true}],"category":["10"],"image":"intro","content":"intro","number":3,"order_by":"rdate","featured":0,"date":"","author":"","categories":"","tags":"tags"}'),
(89, 'Theme Features Additions', 'custom', '{"_widget":{"name":"grid-stack","data":{"width":"1-2","align":"left","breakpoint":"medium","alternate":true,"gutter":true,"gutter_vertical":"default","divider":true,"panel":true,"content_align":true,"animation_media":"slide","animation_content":"slide","media":true,"image_width":"auto","image_height":"auto","media_border":"none","media_overlay":"icon","overlay_animation":"fade","media_animation":"scale","title":true,"content":true,"social_buttons":true,"title_size":"panel","text_align":"left","link":true,"link_style":"button","link_text":"Read more","badge":true,"badge_style":"badge","badge_position":"panel","link_target":false,"class":""}},"items":[{"media":"images\\/yootheme\\/features_additions_gallery.jpg","options":{"media":{"width":900,"height":620}},"title":"Widgetkit Gallery modifier","content":"<p>To give the gallery a chessboard like pattern we have added the <code>.tm-gallery-avanti<\\/code> class. Just add the the class to the general HTML class field in your gallery widget. This class will work best for a 3 item per column setting.<\\/p>\\n\\n<p>This class also adds a special gradient overlay style to the gallery items. If you want to modify these gradients and backgrounds, please take a look at the theme variables in the Customizer.<\\/p>"},{"media":"images\\/yootheme\\/features_additions_condensed.jpg","options":{"media":{"width":900,"height":620}},"title":"Widgetkit Grid modifier","content":"<p>We also added the <code>.tm-margin-condensed<\\/code> class. It reduces the spacing between a widget title and the following content. Just add the class to a grid widget, for example in the HTML class field of the general tab in the widget administration.<\\/p>"}],"_fields":[]}'),
(91, 'Home Header Slideshow', 'custom', '{"_widget":{"name":"slideshow_avanti","data":{"nav":"number","nav_overlay":false,"nav_align":"left","thumbnail_width":"70","thumbnail_height":"70","thumbnail_alt":false,"slidenav":"default","nav_contrast":false,"animation":"swipe","slices":"15","duration":"500","autoplay":false,"interval":"3000","autoplay_pause":true,"kenburns":false,"kenburns_animation":"","kenburns_duration":"15","fullscreen":false,"min_height":"700","media":true,"image_width":"auto","image_height":"auto","overlay":true,"overlay_layout":"middle-left","overlay_content_width":"50","overlay_background":false,"title":true,"content":true,"title_animation":true,"title_size":"large","content_size":"large","link":true,"link_style":"button","link_text":"Learn more","badge":true,"badge_style":"badge","link_target":false,"class":"","overlay_animation":"slide"}},"items":[{"media":"images\\/yootheme\\/demo\\/default\\/home-slideshow-01.jpg","options":{"media":{"width":1920,"height":810}},"title":"Brand Identity.<br> Marketing meets art!","content":"Lorem ipsum dolor sit amet, fringilla vel bibendum dictum, amet eleifend mauris risus sem morbi.","link":"index.php\\/work\\/portfolio"},{"media":"images\\/yootheme\\/demo\\/default\\/home-slideshow-02.jpg","options":{"media":{"width":1920,"height":810}},"title":"We are Avanti.<br> And we will rock you!","content":"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.","link":"index.php\\/company"},{"media":"images\\/yootheme\\/demo\\/default\\/home-slideshow-03.jpg","options":{"media":{"width":1920,"height":810}},"title":"Stop overthinking.<br> Advertise with us!","content":"Orci purus vestibulum nunc conubia, sed erat mauris donec, interdum condimentum mattis tellus.","link":"index.php\\/services"}],"_fields":[]}'),
(92, 'Home Services', 'custom', '{"_widget":{"name":"grid","data":{"grid":"default","gutter":"default","gutter_dynamic":"20","gutter_v_dynamic":"","filter":"none","filter_align":"left","filter_all":true,"columns":"1","columns_small":"2","columns_medium":0,"columns_large":"4","columns_xlarge":0,"panel":"blank","panel_link":false,"animation":"scale-up","media":true,"image_width":"auto","image_height":"auto","media_align":"teaser","media_width":"1-2","media_breakpoint":"medium","content_align":true,"media_border":"none","media_overlay":"none","overlay_animation":"fade","media_animation":"scale","title":true,"content":true,"social_buttons":true,"title_size":"panel","text_align":"center","link":true,"link_style":"button","link_text":"Read more","badge":true,"badge_style":"badge","badge_position":"panel","link_target":false,"class":"","panel_alt":"blank","panel_sequence":false}},"items":[{"title":"Research","media":"images\\/yootheme\\/demo\\/default\\/home-icon_glasses.svg","width":"","options":{"media":{"width":100,"height":100}},"content":"Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy."},{"title":"Brand Identity","media":"images\\/yootheme\\/demo\\/default\\/home-icon_moustache.svg","width":"","options":{"media":{"width":100,"height":100}},"content":"At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren."},{"title":"Advertisement","media":"images\\/yootheme\\/demo\\/default\\/home-icon_graph.svg","width":"","options":{"media":{"width":100,"height":100}},"content":"Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt."},{"title":"Consulting","media":"images\\/yootheme\\/demo\\/default\\/home-icon_cap.svg","width":"","options":{"media":{"width":100,"height":100}},"content":"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque."}],"_fields":[]}'),
(93, 'Home Case Studies', 'custom', '{"_widget":{"name":"slideshow-panel_avanti","data":{"panel":"blank","nav":"dotnav","nav_overlay":true,"nav_align":"right","thumbnail_width":"70","thumbnail_height":"70","thumbnail_alt":false,"slidenav":"default","nav_contrast":true,"animation":"swipe","slices":"15","duration":"500","autoplay":false,"interval":"3000","autoplay_pause":true,"kenburns":false,"kenburns_animation":"","kenburns_duration":"15","fullscreen":false,"min_height":"420","media":true,"image_width":"auto","image_height":"auto","media_align":"left","media_width":"1-2","media_breakpoint":"large","content_align":true,"title":true,"content":true,"title_size":"h1","content_size":"","content_max_width":"60","text_align":"left","link":true,"link_style":"button-link","link_text":"Project details","badge":true,"badge_style":"badge","link_target":false,"class":"","content_panel_width":"60"}},"items":[{"media":"images\\/yootheme\\/demo\\/default\\/home-project-01.jpg","options":{"media":{"width":1280,"height":667}},"title":"Tiger Tea","content":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrudt.<\\/p>","link":"index.php\\/work\\/portfolio","badge":"Brand Identity"},{"title":"Geekz Fashion","media":"images\\/yootheme\\/demo\\/default\\/home-project-02.jpg","width":"1280","height":"667","options":{"media":{"width":1280,"height":667}},"badge":"Web Shop","content":"<p>Mi lacus vel eget, montes pretium, non et curabitur magna, sapien in turpis lacinia. Et tellus ultricies vel sit neque tellus, sit parturient placerat nibh<\\/p>","link":"index.php\\/work\\/gallery"},{"title":"Page Kids Essentials","media":"images\\/yootheme\\/demo\\/default\\/home-project-03.jpg","width":"1280","height":"667","options":{"media":{"width":1280,"height":667}},"badge":"Corporate Identity","content":"<p>Aliquet est sociosqu, donec wisi lacus tincidunt, at eu consectetuer, et volutpat dui senectus, pulvinar senectus torquent ligula loremu tellus dignissim proin.<\\/p>","link":"index.php\\/work\\/single-page"}],"_fields":[{"name":"badge","type":"text","label":"Badge","core":true}]}'),
(94, 'Home Clients Gallery', 'custom', '{"_widget":{"name":"gallery","data":{"grid":"default","gutter":"collapse","gutter_dynamic":"20","gutter_v_dynamic":"","filter":"none","filter_align":"left","filter_all":true,"columns":"1","columns_small":0,"columns_medium":"3","columns_large":0,"columns_xlarge":0,"animation":"scale-up","image_width":"auto","image_height":"auto","media_border":"none","overlay":"center","panel":"blank","overlay_center":"icon","overlay_background":"hover","overlay_image":false,"hover_overlay":false,"overlay_animation":"fade","image_animation":"scale","title":true,"content":true,"title_size":"panel","link":false,"link_style":"button","link_icon":"share","link_text":"View","lightbox":"default","lightbox_caption":"content","lightbox_nav_width":"70","lightbox_nav_height":"70","lightbox_nav_contrast":true,"lightbox_title_size":"panel","lightbox_content_size":"","lightbox_content_width":"","lightbox_width":"auto","lightbox_height":"auto","lightbox_alt":false,"lightbox_link":false,"lightbox_style":"button","lightbox_icon":"search","lightbox_text":"Details","link_target":false,"class":"tm-gallery-avanti"}},"items":[{"title":"Pitch Project","media":"images\\/yootheme\\/widgetkit\\/home-gallery-01.jpg","width":"1200","height":"900","options":{"media":{"width":1200,"height":900}},"content":"kiss-my-css.com","lightbox_content":""},{"title":"UX Design Draft","media":"images\\/yootheme\\/widgetkit\\/home-gallery-02.jpg","width":"1200","height":"900","options":{"media":{"width":1200,"height":900}},"content":"yooka-kola.com","lightbox_content":""},{"title":"Sneak Preview","media":"images\\/yootheme\\/widgetkit\\/home-gallery-03.jpg","width":"1200","height":"900","options":{"media":{"width":1200,"height":900}},"content":"pagekit.com","lightbox_content":""}],"_fields":[{"type":"textarea","name":"lightbox_content","label":"Lightbox Content"}]}'),
(95, 'Portfolio Slideshow', 'custom', '{"_widget":{"name":"slideshow_avanti","data":{"nav":"dotnav","nav_overlay":true,"nav_align":"center","thumbnail_width":"70","thumbnail_height":"70","thumbnail_alt":false,"slidenav":"default","nav_contrast":false,"animation":"fade","slices":"15","duration":"500","autoplay":false,"interval":"3000","autoplay_pause":true,"kenburns":false,"kenburns_animation":"","kenburns_duration":"15","fullscreen":false,"min_height":"600","media":true,"image_width":"auto","image_height":"auto","overlay":true,"overlay_layout":"center","overlay_content_width":"50","overlay_background":true,"title":true,"content":true,"title_size":"large","content_size":"large","link":true,"link_style":"button","link_text":"Read more","badge":true,"badge_style":"badge","link_target":false,"class":"","overlay_animation":"slide"}},"items":[{"title":"We are loving details,<br class=\\"uk-hidden-small\\"> and deliver handmade masterpieces.","media":"images\\/yootheme\\/widgetkit\\/portfolio-slideshow-01.jpg","width":"1920","height":"1080","options":{"media":{"width":1920,"height":1080}}},{"title":"We are loving details,<br class=\\"uk-hidden-small\\"> and deliver handmade masterpieces.","media":"images\\/yootheme\\/widgetkit\\/portfolio-slideshow-02.jpg","width":"1920","height":"1080","options":{"media":{"width":1920,"height":1080}}},{"title":"We are loving details,<br class=\\"uk-hidden-small\\"> and deliver handmade masterpieces.","media":"images\\/yootheme\\/widgetkit\\/portfolio-slideshow-03.jpg","width":"1920","height":"1080","options":{"media":{"width":1920,"height":1080}}}],"_fields":[]}'),
(96, 'Portfolio Projects 1', 'custom', '{"_widget":{"name":"slideshow-panel_avanti","data":{"panel":"blank","nav":"dotnav","nav_overlay":true,"nav_align":"right","thumbnail_width":"70","thumbnail_height":"70","thumbnail_alt":false,"slidenav":"default","nav_contrast":true,"animation":"swipe","slices":"15","duration":"500","autoplay":false,"interval":"3000","autoplay_pause":true,"kenburns":false,"kenburns_animation":"","kenburns_duration":"15","fullscreen":false,"min_height":"420","media":true,"image_width":"auto","image_height":"auto","media_align":"left","media_width":"1-2","media_breakpoint":"large","content_align":true,"title":true,"content":true,"title_size":"h1","content_size":"","content_max_width":"60","text_align":"left","link":true,"link_style":"button-link","link_text":"Project details","badge":true,"badge_style":"badge","link_target":false,"class":""}},"items":[{"media":"images\\/yootheme\\/widgetkit\\/portfolio-project-01.jpg","options":{"media":{"width":1280,"height":667}},"title":"Bender Guitars","content":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrudt.<\\/p>","link":"index.php\\/work\\/single-page","badge":"Brand Identity"},{"title":"Tiger Tea","media":"images\\/yootheme\\/widgetkit\\/portfolio-project-02.jpg","width":"1280","height":"667","options":{"media":{"width":1280,"height":667}},"badge":"Web Shop","content":"<p>Mi lacus vel eget, montes pretium, non et curabitur magna, sapien in turpis lacinia. Et tellus ultricies vel sit neque tellus, sit parturient placerat nibh<\\/p>","link":"index.php\\/work\\/single-page"},{"title":"Mascapone Cars","media":"images\\/yootheme\\/widgetkit\\/portfolio-project-03.jpg","width":"1280","height":"667","options":{"media":{"width":1280,"height":667}},"badge":"Corporate Identity","content":"<p>Aliquet est sociosqu, donec wisi lacus tincidunt, at eu consectetuer, et volutpat dui senectus, pulvinar senectus torquent ligula loremu tellus dignissim proin.<\\/p>","link":"index.php\\/work\\/single-page"}],"_fields":[{"name":"badge","type":"text","label":"Badge","core":true}]}'),
(97, 'Portfolio Projects 2', 'custom', '{"_widget":{"name":"slideshow-panel_avanti","data":{"panel":"blank","nav":"dotnav","nav_overlay":true,"nav_align":"left","thumbnail_width":"70","thumbnail_height":"70","thumbnail_alt":false,"slidenav":"default","nav_contrast":false,"animation":"swipe","slices":"15","duration":"500","autoplay":false,"interval":"3000","autoplay_pause":true,"kenburns":false,"kenburns_animation":"","kenburns_duration":"15","fullscreen":false,"min_height":"420","media":true,"image_width":"auto","image_height":"auto","media_align":"right","media_width":"1-2","media_breakpoint":"large","content_align":true,"title":true,"content":true,"title_size":"h1","content_size":"","content_max_width":"60","text_align":"left","link":true,"link_style":"button-link","link_text":"Project details","badge":true,"badge_style":"badge","link_target":false,"class":""}},"items":[{"media":"images\\/yootheme\\/widgetkit\\/portfolio-project-04.jpg","options":{"media":{"width":1280,"height":667}},"title":"Charger Motors","content":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrudt.<\\/p>","link":"index.php\\/work\\/single-page","badge":"Brand Identity"},{"title":"Boreal Campaigne","media":"images\\/yootheme\\/widgetkit\\/portfolio-project-05.jpg","width":"1280","height":"667","options":{"media":{"width":1280,"height":667}},"badge":"Web Shop","content":"<p>Mi lacus vel eget, montes pretium, non et curabitur magna, sapien in turpis lacinia. Et tellus ultricies vel sit neque tellus, sit parturient placerat nibh<\\/p>","link":"index.php\\/work\\/single-page"},{"title":"Creative Mess","media":"images\\/yootheme\\/widgetkit\\/portfolio-project-06.jpg","width":"1280","height":"667","options":{"media":{"width":1280,"height":667}},"badge":"Corporate Identity","content":"<p>Aliquet est sociosqu, donec wisi lacus tincidunt, at eu consectetuer, et volutpat dui senectus, pulvinar senectus torquent ligula loremu tellus dignissim proin.<\\/p>","link":"index.php\\/work\\/single-page"}],"_fields":[{"name":"badge","type":"text","label":"Badge","core":true}]}'),
(98, 'Portfolio Projects 3', 'custom', '{"_widget":{"name":"slideshow-panel_avanti","data":{"panel":"blank","nav":"dotnav","nav_overlay":true,"nav_align":"right","thumbnail_width":"70","thumbnail_height":"70","thumbnail_alt":false,"slidenav":"default","nav_contrast":true,"animation":"swipe","slices":"15","duration":"500","autoplay":false,"interval":"3000","autoplay_pause":true,"kenburns":false,"kenburns_animation":"","kenburns_duration":"15","fullscreen":false,"min_height":"420","media":true,"image_width":"auto","image_height":"auto","media_align":"left","media_width":"1-2","media_breakpoint":"large","content_align":true,"title":true,"content":true,"title_size":"h1","content_size":"","content_max_width":"60","text_align":"left","link":true,"link_style":"button-link","link_text":"Project details","badge":true,"badge_style":"badge","link_target":false,"class":""}},"items":[{"media":"images\\/yootheme\\/widgetkit\\/portfolio-project-07.jpg","options":{"media":{"width":1280,"height":667}},"title":"Geekz Fashion","content":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrudt.<\\/p>","link":"index.php\\/work\\/single-page","badge":"Brand Identity"},{"title":"UIkit Framework","media":"images\\/yootheme\\/widgetkit\\/portfolio-project-08.jpg","width":"1280","height":"667","options":{"media":{"width":1280,"height":667}},"badge":"Web Shop","content":"<p>Mi lacus vel eget, montes pretium, non et curabitur magna, sapien in turpis lacinia. Et tellus ultricies vel sit neque tellus, sit parturient placerat nibh<\\/p>","link":"index.php\\/work\\/single-page"},{"title":"Warp Framework","media":"images\\/yootheme\\/widgetkit\\/portfolio-project-09.jpg","width":"1280","height":"667","options":{"media":{"width":1280,"height":667}},"badge":"Corporate Identity","content":"<p>Aliquet est sociosqu, donec wisi lacus tincidunt, at eu consectetuer, et volutpat dui senectus, pulvinar senectus torquent ligula loremu tellus dignissim proin.<\\/p>","link":"index.php\\/work\\/single-page"}],"_fields":[{"name":"badge","type":"text","label":"Badge","core":true}]}'),
(99, 'Portfolio Gallery', 'custom', '{"_widget":{"name":"gallery","data":{"grid":"default","gutter":"collapse","gutter_dynamic":"20","gutter_v_dynamic":"","filter":"none","filter_align":"left","filter_all":true,"columns":"1","columns_small":"2","columns_medium":0,"columns_large":"3","columns_xlarge":0,"animation":"fade","image_width":"auto","image_height":"auto","media_border":"none","overlay":"center","panel":"blank","overlay_center":"icon","overlay_background":"hover","overlay_image":false,"hover_overlay":true,"overlay_animation":"fade","image_animation":"grayscale","title":true,"content":true,"title_size":"panel","link":false,"link_style":"button","link_icon":"share","link_text":"View","lightbox":"default","lightbox_caption":"content","lightbox_nav_width":"70","lightbox_nav_height":"70","lightbox_nav_contrast":true,"lightbox_title_size":"panel","lightbox_content_size":"","lightbox_content_width":"","lightbox_width":"auto","lightbox_height":"auto","lightbox_alt":false,"lightbox_link":false,"lightbox_style":"button","lightbox_icon":"search","lightbox_text":"Details","link_target":false,"class":"tm-gallery-avanti"}},"items":[{"title":"Helios Corporated","media":"images\\/yootheme\\/widgetkit\\/portfolio-gallery-01.jpg","width":"960","height":"648","options":{"media":{"width":960,"height":648}},"content":"www.yootheme.com"},{"title":"Coffee Junkies","media":"images\\/yootheme\\/widgetkit\\/portfolio-gallery-02.jpg","width":"960","height":"648","options":{"media":{"width":960,"height":648}},"content":"www.yootheme.com"},{"title":"Pagekit","media":"images\\/yootheme\\/widgetkit\\/portfolio-gallery-03.jpg","width":"960","height":"648","options":{"media":{"width":960,"height":648}},"content":"www.yootheme.com"},{"title":"Gusto Essentials","media":"images\\/yootheme\\/widgetkit\\/portfolio-gallery-04.jpg","width":"960","height":"648","options":{"media":{"width":960,"height":648}},"content":"www.yootheme.com"},{"title":"Mashed Fashion","media":"images\\/yootheme\\/widgetkit\\/portfolio-gallery-05.jpg","width":"960","height":"648","options":{"media":{"width":960,"height":648}},"content":"www.yootheme.com"},{"title":"La Fleur Magazine","media":"images\\/yootheme\\/widgetkit\\/portfolio-gallery-06.jpg","width":"960","height":"648","options":{"media":{"width":960,"height":648}},"content":"www.yootheme.com"},{"title":"Aurora Agency","media":"images\\/yootheme\\/widgetkit\\/portfolio-gallery-07.jpg","width":"960","height":"648","options":{"media":{"width":960,"height":648}},"content":"www.yootheme.com"},{"title":"Bella Fashion","media":"images\\/yootheme\\/widgetkit\\/portfolio-gallery-08.jpg","width":"960","height":"648","options":{"media":{"width":960,"height":648}},"content":"www.yootheme.com"},{"title":"Nite Owls","media":"images\\/yootheme\\/widgetkit\\/portfolio-gallery-09.jpg","width":"960","height":"648","options":{"media":{"width":960,"height":648}},"content":"www.yootheme.com"}],"_fields":[{"type":"textarea","name":"lightbox_content","label":"Lightbox Content"}]}'),
(101, 'Gallery', 'custom', '{"_widget":{"name":"gallery","data":{"grid":"dynamic","gutter":"collapse","gutter_dynamic":"30","gutter_v_dynamic":"","filter":"text","filter_align":"center","filter_all":true,"columns":"1","columns_small":"2","columns_medium":0,"columns_large":"3","columns_xlarge":0,"animation":"scale-up","image_width":"auto","image_height":"auto","media_border":"none","overlay":"bottom","panel":"blank","overlay_center":"icon","overlay_background":"hover","overlay_image":false,"hover_overlay":true,"overlay_animation":"slide-bottom","image_animation":"scale","title":true,"content":true,"title_size":"panel","link":false,"link_style":"button","link_icon":"share","link_text":"View","lightbox":"default","lightbox_caption":"content","lightbox_nav_width":"70","lightbox_nav_height":"70","lightbox_nav_contrast":true,"lightbox_title_size":"panel","lightbox_content_size":"","lightbox_content_width":"","lightbox_width":"auto","lightbox_height":"auto","lightbox_alt":false,"lightbox_link":false,"lightbox_style":"button","lightbox_icon":"search","lightbox_text":"Details","link_target":false,"class":"tm-gallery-avanti"}},"items":[{"title":"Helios Corporated","media":"images\\/yootheme\\/widgetkit\\/gallery-01.jpg","width":"960","height":"648","options":{"media":{"width":640,"height":707}},"content":"www.yootheme.com","tags":["Webdesign"]},{"title":"Coffee Junkies","media":"images\\/yootheme\\/widgetkit\\/gallery-02.jpg","width":"960","height":"648","options":{"media":{"width":640,"height":455}},"content":"www.yootheme.com","tags":["Commercials"]},{"title":"Pagekit","media":"images\\/yootheme\\/widgetkit\\/gallery-03.jpg","width":"960","height":"648","options":{"media":{"width":640,"height":707}},"content":"www.yootheme.com","tags":["Webdesign"]},{"title":"Gusto Essentials","media":"images\\/yootheme\\/widgetkit\\/gallery-04.jpg","width":"960","height":"648","options":{"media":{"width":640,"height":707}},"content":"www.yootheme.com","tags":["Print Essentials"]},{"title":"Mashed Fashion","media":"images\\/yootheme\\/widgetkit\\/gallery-05.jpg","width":"960","height":"648","options":{"media":{"width":640,"height":455}},"content":"www.yootheme.com","tags":["Webdesign","Commercials"]},{"title":"La Fleur Magazine","media":"images\\/yootheme\\/widgetkit\\/gallery-06.jpg","width":"960","height":"648","options":{"media":{"width":640,"height":455}},"content":"www.yootheme.com","tags":["Print Essentials","Commercials"]},{"title":"Aurora Agency","media":"images\\/yootheme\\/widgetkit\\/gallery-07.jpg","width":"960","height":"648","options":{"media":{"width":640,"height":455}},"content":"www.yootheme.com","tags":["Webdesign","Print Essentials"]},{"title":"Bella Fashion","media":"images\\/yootheme\\/widgetkit\\/gallery-08.jpg","width":"960","height":"648","options":{"media":{"width":640,"height":707}},"content":"www.yootheme.com","tags":["Commercials"]},{"title":"Nite Owls","media":"images\\/yootheme\\/widgetkit\\/gallery-09.jpg","width":"960","height":"648","options":{"media":{"width":640,"height":707}},"content":"www.yootheme.com","tags":["Commercials"]}],"_fields":[{"type":"textarea","name":"lightbox_content","label":"Lightbox Content"},{"name":"tags","type":"tags","label":"Tags","core":true}]}'),
(103, 'Gallery Clients', 'custom', '{"_widget":{"name":"grid_avanti","data":{"grid":"dynamic","gutter":"default","gutter_dynamic":"20","gutter_v_dynamic":"","filter":"none","filter_align":"left","filter_all":true,"columns":"1","columns_small":"2","columns_medium":"3","columns_large":"4","columns_xlarge":0,"divider":false,"panel":"space","panel_link":false,"animation":"fade","media":true,"image_width":"auto","image_height":"auto","media_align":"teaser","media_width":"1-2","media_breakpoint":"medium","content_align":true,"media_border":"none","media_overlay":"none","overlay_animation":"fade","media_animation":"scale","title":true,"title_truncate":"","content":true,"content_truncate":"","social_buttons":true,"title_size":"h4","text_align":"left","link":true,"link_style":"button","link_text":"Read more","badge":true,"badge_style":"badge","badge_position":"panel","link_target":false,"class":"uk-link-muted"}},"items":[{"media":"","options":{"media":[]},"title":"A","content":"<a href=\\"#\\">AAsystems<\\/a><br>\\n<a href=\\"#\\">Alpha Romantico<\\/a><br>\\n<a href=\\"#\\">Automato<\\/a>"},{"media":"","title":"B","content":"<a href=\\"#\\">Baboon<\\/a><br>\\n<a href=\\"#\\">Betenego<\\/a><br>\\n<a href=\\"#\\">Boreal Expert<\\/a><br>\\n<a href=\\"#\\">Bruisers Inc<\\/a>"},{"media":"","title":"C","content":"<a href=\\"#\\">Cargo Fargo<\\/a><br>\\n<a href=\\"#\\">Cheetah<\\/a><br>\\n<a href=\\"#\\">Cugar Cigars<\\/a>"},{"media":"","title":"D","content":"<a href=\\"#\\">Didier Sachs<\\/a><br>\\n<a href=\\"#\\">Dragon Fly<\\/a><br>\\n<a href=\\"#\\">Duck Taylor<\\/a><br>\\n<a href=\\"#\\">D-Mobile<\\/a>"},{"media":"","title":"G","content":"<a href=\\"#\\">Gabba Gondor<\\/a><br>\\n<a href=\\"#\\">Genetics Inc<\\/a><br>\\n<a href=\\"#\\">Gordon\\u2019s Gin<\\/a><br>\\n<a href=\\"#\\">Gucci & Gobbana<\\/a>"},{"media":"","title":"K","content":"<a href=\\"#\\">Kaboom<\\/a><br>\\n<a href=\\"#\\">Kraken Graphics<\\/a>"},{"media":"","title":"M","content":"<a href=\\"#\\">Marry Flowers<\\/a><br>\\n<a href=\\"#\\">Mecca Benz<\\/a><br>\\n<a href=\\"#\\">Mike Athletics<\\/a><br>\\n<a href=\\"#\\">Molly McGuire<\\/a><br>\\n<a href=\\"#\\">Moreno Pictures<\\/a><br>\\n<a href=\\"#\\">Murati Cosmetcis<\\/a>"},{"media":"","title":"N","content":"<a href=\\"#\\">Narcotics<\\/a><br>\\n<a href=\\"#\\">Norega Tabacco<\\/a><br>\\n<a href=\\"#\\">Nutrition Extreme<\\/a>"},{"media":"","title":"L","content":"<a href=\\"#\\">Lagers Best<\\/a><br>\\n<a href=\\"#\\">Lagoonics<\\/a>"},{"media":"","title":"R","content":"<a href=\\"#\\">Razer Sharp<\\/a><br>\\n<a href=\\"#\\">Regenetics<\\/a><br>\\n<a href=\\"#\\">Rofl Inc<\\/a>"},{"media":"","title":"S","content":"<a href=\\"#\\">Saabor<\\/a><br>\\n<a href=\\"#\\">Savegames<\\/a><br>\\n<a href=\\"#\\">Seed Plants<\\/a><br>\\n<a href=\\"#\\">Silly Stupids<\\/a><br>\\n<a href=\\"#\\">Strong Steel<\\/a><br>\\n<a href=\\"#\\">Suvenor<\\/a>"},{"media":"","title":"T","content":"<a href=\\"#\\">Tan Ming<\\/a><br>\\n<a href=\\"#\\">Titan Games<\\/a><br>\\n<a href=\\"#\\">Tokio Motels<\\/a>"}],"_fields":[]}');
INSERT INTO `#__widgetkit` (`id`, `name`, `type`, `data`) VALUES
(104, 'Services Special Fields', 'custom', '{"_widget":{"name":"grid","data":{"grid":"default","gutter":"default","gutter_dynamic":"20","gutter_v_dynamic":"","filter":"none","filter_align":"left","filter_all":true,"columns":"1","columns_small":"2","columns_medium":"0","columns_large":"0","columns_xlarge":0,"panel":"blank","panel_link":false,"animation":"none","media":true,"image_width":"auto","image_height":"auto","media_align":"left","media_width":"3-10","media_breakpoint":"medium","content_align":true,"media_border":"none","media_overlay":"none","overlay_animation":"fade","media_animation":"scale","title":true,"content":true,"social_buttons":true,"title_size":"panel","text_align":"left","link":true,"link_style":"button","link_text":"Read more","badge":true,"badge_style":"badge","badge_position":"panel","link_target":false,"class":"uk-text-center-small","panel_alt":"blank","panel_sequence":false}},"items":[{"title":"Research","media":"images\\/yootheme\\/widgetkit\\/services-icon_glasses.svg","width":"","options":{"media":{"width":130,"height":130}},"content":"Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy."},{"title":"Brand Identity","media":"images\\/yootheme\\/widgetkit\\/services-icon_moustache.svg","width":"","options":{"media":{"width":130,"height":130}},"content":"At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren."},{"title":"Advertisement","media":"images\\/yootheme\\/widgetkit\\/services-icon_graph.svg","width":"","options":{"media":{"width":130,"height":130}},"content":"Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt."},{"title":"Consulting","media":"images\\/yootheme\\/widgetkit\\/services-icon_cap.svg","width":"","options":{"media":{"width":130,"height":130}},"content":"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque."}],"_fields":[]}'),
(105, 'Services Advertisement', 'custom', '{"_widget":{"name":"switcher","data":{"nav":"nav","thumbnail_width":"70","thumbnail_height":"70","thumbnail_alt":false,"position":"left","alignment":"left","width":"1-2","panel":false,"animation":"slide-horizontal","media":true,"image_width":"auto","image_height":"auto","media_align":"top","media_width":"1-2","media_breakpoint":"medium","content_align":true,"media_border":"none","media_overlay":"none","overlay_animation":"fade","media_animation":"scale","title":false,"content":true,"social_buttons":true,"title_size":"h4","text_align":"left","link":true,"link_style":"button","link_text":"Read more","link_target":false,"class":""}},"items":[{"title":"Print Essentials","media":"images\\/yootheme\\/widgetkit\\/services-switcher-01.jpg","width":"960","height":"560","options":{"media":{"width":960,"height":560}},"content":"<h6 class=\\"uk-margin-top-remove uk-text-primary\\">Print Essentials<\\/h6>\\n<h2 class=\\"uk-margin-small-top\\">Professional Identity Essentials<\\/h2>\\n<p>Lorem ipsum dolor sit amet, libero montes rhoncus et feugiat, lectus metus natoque, eu dolor amet vitae in a. Sapien etiam consequat. Ante proin nunc sed justo, imperdiet diam fringilla sem eget ante interdum, urna tempor nisl. At nam magna vestibulum eget et, orci wisi. Integer nullam nisl ac urna non.<\\/p>"},{"title":"Commercials","media":"images\\/yootheme\\/widgetkit\\/services-switcher-02.jpg","width":"960","height":"560","options":{"media":{"width":960,"height":560}},"content":"<h6 class=\\"uk-margin-top-remove uk-text-primary\\">Commercials<\\/h6>\\n<h2 class=\\"uk-margin-small-top\\">Appealing TV and Web Spots<\\/h2>\\n<p>Condimentum interdum rerum nunc augue sit diam, cum velit euismod montes, condimentum eu wisi. Venenatis luctus lacus, eget leo sed fringilla, aenean qui commodo lorem enim, turpis malesuada elit metus. Ac et felis, tincidunt turpis velit nunc ultricies sed.<\\/p>"},{"title":"Web Design","media":"images\\/yootheme\\/widgetkit\\/services-switcher-03.jpg","width":"960","height":"560","options":{"media":{"width":960,"height":560}},"content":"<h6 class=\\"uk-margin-top-remove uk-text-primary\\">Web Design<\\/h6>\\n<h2 class=\\"uk-margin-small-top\\">Handcrafted and unique websites<\\/h2>\\n<p>Auctor dolor sit eget nonummy. Sollicitudin diam arcu facilisis tempus volutpat mi, massa sem elit, dui vivamus, tellus metus, sapien aliquam ut. Fermentum tincidunt euismod hac arcu. Curabitur sit porta integer.<\\/p>"}],"_fields":[]}'),
(106, 'Services Infos', 'custom', '{"_widget":{"name":"slideshow-panel_avanti","data":{"panel":"blank","nav":"dotnav","nav_overlay":true,"nav_align":"center","thumbnail_width":"70","thumbnail_height":"70","thumbnail_alt":false,"slidenav":"default","nav_contrast":true,"animation":"swipe","slices":"15","duration":"500","autoplay":false,"interval":"3000","autoplay_pause":true,"kenburns":false,"kenburns_animation":"","kenburns_duration":"15","fullscreen":false,"min_height":"500","media":true,"image_width":"auto","image_height":"auto","media_align":"left","media_width":"1-2","media_breakpoint":"medium","content_align":true,"title":true,"content":true,"title_size":"h1","content_size":"","content_max_width":"60","text_align":"left","link":true,"link_style":"button-link","link_text":"Contact us","badge":true,"badge_style":"badge","link_target":false,"class":""}},"items":[{"media":"images\\/yootheme\\/widgetkit\\/services-panel-01.jpg","options":{"media":{"width":1280,"height":667}},"title":"Increase your popularity","content":"<ul class=\\"uk-list  uk-list-line\\">\\n<li><i class=\\"uk-theme-icon-check\\"><\\/i> Analyizing the market of your business<\\/li>\\n<li><i class=\\"uk-theme-icon-check\\"><\\/i> Researching the global market<\\/li>\\n<li><i class=\\"uk-theme-icon-check\\"><\\/i> Search Engine Optimization<\\/li>\\n<li><i class=\\"uk-theme-icon-check\\"><\\/i> Business improvements and advices<\\/li>\\n<\\/ul>","link":"index.php\\/company"},{"media":"images\\/yootheme\\/widgetkit\\/services-panel-02.jpg","options":{"media":{"width":1280,"height":667}},"title":"Start small, grow fast.","content":"<ul class=\\"uk-list uk-list-line\\">\\n<li><i class=\\"uk-theme-icon-check\\"><\\/i> Analyizing the market of your business<\\/li>\\n<li><i class=\\"uk-theme-icon-check\\"><\\/i> Researching the global market<\\/li>\\n<li><i class=\\"uk-theme-icon-check\\"><\\/i> Search Engine Optimization<\\/li>\\n<li><i class=\\"uk-theme-icon-check\\"><\\/i> Business improvements and advices<\\/li>\\n<\\/ul>","link":"index.php\\/company"}],"_fields":[]}'),
(107, 'Services Testimonials', 'custom', '{"_widget":{"name":"switcher","data":{"nav":"dotnav","thumbnail_width":"70","thumbnail_height":"70","thumbnail_alt":false,"position":"bottom","alignment":"center","width":"1-4","panel":false,"animation":"fade","media":true,"image_width":"150","image_height":"150","media_align":"right","media_width":"3-10","media_breakpoint":"medium","content_align":true,"media_border":"circle","media_overlay":"none","overlay_animation":"fade","media_animation":"scale","title":true,"content":true,"social_buttons":true,"title_size":"h4","text_align":"left","link":true,"link_style":"button","link_text":"Read more","link_target":false,"class":""}},"items":[{"media":"images\\/yootheme\\/widgetkit\\/services-avatar-01.jpg","options":{"media":{"width":400,"height":400}},"content":"<blockquote>\\n<p>\\u201cWe needed a brand new identity for our product and we got in touch with Avanti. We were really surprised of the results and will continue our partnership for a long time. \\u201d<\\/p>\\n<\\/blockquote>\\n<p>\\n<small class=\\"uk-h6\\">Danny Sanchez<\\/small><br>\\n<span class=\\"uk-text-primary\\">CEO of YOOka Kola<\\/span>\\n<\\/p>","title":"YOOka Kola"},{"media":"images\\/yootheme\\/widgetkit\\/services-avatar-02.jpg","options":{"media":{"width":400,"height":400}},"content":"<blockquote>\\n<p>\\u201cLorem ipsum dolor sit amet, nonummy duis vestibulum, vitae integer dapibus nonummy, eros maecenas nulla quis, integer maecenas\\u201d<\\/p>\\n<\\/blockquote>\\n<p>\\n<small class=\\"uk-h6\\">Diego Moralez<\\/small><br>\\n<span class=\\"uk-text-primary\\">Engineer at Charger Motors<\\/span>\\n<\\/p>","title":"Charger Motors"},{"media":"images\\/yootheme\\/widgetkit\\/services-avatar-03.jpg","options":{"media":{"width":400,"height":400}},"title":"Geekz Fashion","content":"<blockquote>\\n<p>\\u201cSuspendisse leo sed. Quis ante quis pellentesque, commodo scelerisque fringilla metus, quis vehicula felis placerat sodales sodales id, semper molestie, amet etiam aliqua placerat risus.\\u201d<\\/p>\\n<\\/blockquote>\\n<p>\\n<small class=\\"uk-h6\\">Charlie Harper<\\/small><br>\\n<span class=\\"uk-text-primary\\">Founder of Geekz Fashion<\\/span>\\n<\\/p>"}],"_fields":[]}'),
(108, 'Company Gallery', 'custom', '{"_widget":{"name":"gallery","data":{"grid":"dynamic","gutter":"default","gutter_dynamic":"20","gutter_v_dynamic":"","filter":"none","filter_align":"left","filter_all":true,"columns":"2","columns_small":0,"columns_medium":0,"columns_large":0,"columns_xlarge":0,"animation":"none","image_width":"auto","image_height":"auto","media_border":"none","overlay":"default","panel":"blank","overlay_center":"icon","overlay_background":"hover","overlay_image":false,"hover_overlay":true,"overlay_animation":"fade","image_animation":"scale","title":false,"content":false,"title_size":"panel","link":false,"link_style":"button","link_icon":"share","link_text":"View","lightbox":"default","lightbox_caption":"content","lightbox_nav_width":"70","lightbox_nav_height":"70","lightbox_nav_contrast":true,"lightbox_title_size":"panel","lightbox_content_size":"","lightbox_content_width":"","lightbox_width":"auto","lightbox_height":"auto","lightbox_alt":false,"lightbox_link":false,"lightbox_style":"button","lightbox_icon":"search","lightbox_text":"Details","link_target":false,"class":""}},"items":[{"title":"Company Gallery 01","media":"images\\/yootheme\\/widgetkit\\/company-gallery-01.jpg","width":"960","height":"640","options":{"media":{"width":960,"height":640}}},{"title":"Company Gallery 02","media":"images\\/yootheme\\/widgetkit\\/company-gallery-02.jpg","width":"960","height":"640","options":{"media":{"width":960,"height":640}}},{"title":"Company Gallery 03","media":"images\\/yootheme\\/widgetkit\\/company-gallery-03.jpg","width":"960","height":"640","options":{"media":{"width":960,"height":640}}},{"title":"Company Gallery 04","media":"images\\/yootheme\\/widgetkit\\/company-gallery-04.jpg","width":"960","height":"640","options":{"media":{"width":960,"height":640}}}],"_fields":[{"type":"textarea","name":"lightbox_content","label":"Lightbox Content"}]}'),
(109, 'Company Jobs', 'custom', '{"_widget":{"name":"accordion","data":{"collapse":true,"first_item":true,"media":true,"image_width":"auto","image_height":"auto","media_align":"top","media_width":"1-2","media_breakpoint":"medium","content_align":true,"media_border":"none","media_overlay":"icon","overlay_animation":"fade","media_animation":"scale","title":false,"content":true,"social_buttons":true,"title_size":"h3","text_align":"left","link":true,"link_style":"button","link_text":"Read more","link_target":false,"class":""}},"items":[{"media":"","options":{"media":[]},"title":"Communcation & Finances","content":"<p>Lorem ipsum dolor sit amet, risus wisi amet wisi, est justo feugiat et ac. Donec varius, iaculis sed aptent ultricies tempor in etiam. Consectetuer leo fusce.<\\/p>\\n\\n<ul class=\\"uk-list uk-list-space\\">\\n<li><i class=\\"uk-theme-icon-check uk-text-primary\\"><\\/i> College degree<\\/li>\\n<li><i class=\\"uk-theme-icon-check uk-text-primary\\"><\\/i> 3 years of expierence in a similiar business<\\/li>\\n<li><i class=\\"uk-theme-icon-check uk-text-primary\\"><\\/i> Average looking and very funny person<\\/li>\\n<\\/ul>"},{"media":"","content":"<p>Lorem ipsum dolor sit amet, risus wisi amet wisi, est justo feugiat et ac. Donec varius, iaculis sed aptent ultricies tempor in etiam. Consectetuer leo fusce.<\\/p>\\n\\n<ul class=\\"uk-list uk-list-space\\">\\n<li><i class=\\"uk-theme-icon-check uk-text-primary\\"><\\/i> College degree<\\/li>\\n<li><i class=\\"uk-theme-icon-check uk-text-primary\\"><\\/i> 3 years of expierence in a similiar business<\\/li>\\n<li><i class=\\"uk-theme-icon-check uk-text-primary\\"><\\/i> Average looking and very funny person<\\/li>\\n<\\/ul>","title":"Junior Art Director"},{"media":"","content":"<p>Lorem ipsum dolor sit amet, risus wisi amet wisi, est justo feugiat et ac. Donec varius, iaculis sed aptent ultricies tempor in etiam. Consectetuer leo fusce.<\\/p>\\n\\n<ul class=\\"uk-list uk-list-space\\">\\n<li><i class=\\"uk-theme-icon-check uk-text-primary\\"><\\/i> College degree<\\/li>\\n<li><i class=\\"uk-theme-icon-check uk-text-primary\\"><\\/i> 3 years of expierence in a similiar business<\\/li>\\n<li><i class=\\"uk-theme-icon-check uk-text-primary\\"><\\/i> Average looking and very funny person<\\/li>\\n<\\/ul>","title":"Marketing Guy"}],"_fields":[]}'),
(110, 'Company Leading Team', 'custom', '{"_widget":{"name":"grid_avanti","data":{"grid":"default","gutter":"default","gutter_dynamic":"20","gutter_v_dynamic":"","filter":"none","filter_align":"left","filter_all":true,"columns":"1","columns_small":0,"columns_medium":"3","columns_large":0,"columns_xlarge":0,"divider":false,"panel":"box","panel_link":true,"animation":"none","media":true,"image_width":"auto","image_height":"auto","media_align":"teaser","media_width":"1-2","media_breakpoint":"medium","content_align":true,"media_border":"none","media_overlay":"social-buttons","overlay_animation":"fade","media_animation":"scale","title":true,"title_truncate":"","content":true,"content_truncate":"","social_buttons":true,"title_size":"h5","text_align":"center","link":false,"link_style":"button","link_text":"Read more","badge":true,"badge_style":"badge","badge_position":"panel","link_target":false,"class":"tm-margin-condensed"}},"items":[{"title":"Johnny Handsome","media":"images\\/yootheme\\/widgetkit\\/company-team-01.jpg","width":"960","height":"880","options":{"media":{"width":960,"height":880}},"content":"Founder, CEO","link":"#","facebook":"#","twitter":"#"},{"title":"Suzi Q","media":"images\\/yootheme\\/widgetkit\\/company-team-02.jpg","width":"960","height":"880","options":{"media":{"width":960,"height":880}},"content":"Founder, Art Director","link":"#","facebook":"#","twitter":"#"},{"title":"Martin Miller","media":"images\\/yootheme\\/widgetkit\\/company-team-03.jpg","width":"960","height":"880","options":{"media":{"width":960,"height":880}},"content":"Founder, Financials","link":"#","facebook":"#","twitter":"#"}],"_fields":[{"type":"textarea","name":"lightbox_content","label":"Lightbox Content"}]}'),
(111, 'Company Creative Team', 'custom', '{"_widget":{"name":"grid_avanti","data":{"grid":"default","gutter":"default","gutter_dynamic":"20","gutter_v_dynamic":"","filter":"none","filter_align":"left","filter_all":true,"columns":"1","columns_small":"2","columns_medium":"4","columns_large":0,"columns_xlarge":0,"divider":false,"panel":"box","panel_link":true,"animation":"none","media":true,"image_width":"auto","image_height":"auto","media_align":"teaser","media_width":"1-2","media_breakpoint":"medium","content_align":true,"media_border":"none","media_overlay":"social-buttons","overlay_animation":"fade","media_animation":"scale","title":true,"title_truncate":"","content":true,"content_truncate":"","social_buttons":true,"title_size":"h5","text_align":"center","link":false,"link_style":"button","link_text":"Read more","badge":true,"badge_style":"badge","badge_position":"panel","link_target":false,"class":"tm-margin-condensed"}},"items":[{"title":"Pretty Woman","media":"images\\/yootheme\\/widgetkit\\/company-team-04.jpg","width":"960","height":"880","options":{"media":{"width":960,"height":880}},"content":"Looks just cute","link":"#","facebook":"#","twitter":"#"},{"title":"John Hancock","media":"images\\/yootheme\\/widgetkit\\/company-team-05.jpg","width":"960","height":"880","options":{"media":{"width":960,"height":880}},"content":"Art Director","link":"#","facebook":"#","twitter":"#"},{"title":"Nerdy McGuire","media":"images\\/yootheme\\/widgetkit\\/company-team-06.jpg","width":"960","height":"880","options":{"media":{"width":960,"height":880}},"content":"Marketing Analyst","link":"#","facebook":"#","twitter":"#"},{"media":"images\\/yootheme\\/widgetkit\\/company-team-07.jpg","options":{"media":{"width":960,"height":880}},"title":"Jared Leto","content":"Business Strategist","link":"#","facebook":"#","twitter":"#"}],"_fields":[{"type":"textarea","name":"lightbox_content","label":"Lightbox Content"},{"name":"facebook","type":"text","label":"Facebook","core":true},{"name":"twitter","type":"text","label":"Twitter","core":true}]}'),
(112, 'Single Slideshow', 'custom', '{"_widget":{"name":"slideshow","data":{"nav":"thumbnails","nav_overlay":true,"nav_align":"center","thumbnail_width":"100","thumbnail_height":"60","thumbnail_alt":false,"slidenav":"default","nav_contrast":false,"animation":"fade","slices":"15","duration":"500","autoplay":false,"interval":"3000","autoplay_pause":true,"kenburns":true,"kenburns_animation":"","kenburns_duration":"15","fullscreen":false,"min_height":"400","media":true,"image_width":"auto","image_height":"auto","overlay":"center","overlay_animation":"slide","overlay_background":true,"title":true,"content":false,"title_size":"large","content_size":"","link":true,"link_style":"button","link_text":"Read more","badge":true,"badge_style":"badge","link_target":false,"class":""}},"items":[{"title":"Avanti Theme","media":"images\\/yootheme\\/widgetkit\\/single-slideshow-01.jpg","width":"1200","height":"600","options":{"media":{"width":1600,"height":800}},"content":"January 2016 club theme"},{"title":"Six delicious styles","media":"images\\/yootheme\\/widgetkit\\/single-slideshow-02.jpg","width":"1200","height":"600","options":{"media":{"width":1600,"height":800}},"content":"width detailed demo pages"},{"title":"Nice features","media":"images\\/yootheme\\/widgetkit\\/single-slideshow-03.jpg","width":"1200","height":"600","options":{"media":{"width":1600,"height":800}},"content":"like useful navbar options and the latest widgetkit"}],"_fields":[]}'),
(113, 'Single Page More Projects', 'custom', '{"_widget":{"name":"grid-slider","data":{"grid":"default","gutter":"default","gutter_dynamic":"20","gutter_v_dynamic":"","filter":"none","filter_align":"left","filter_all":true,"columns":"1","columns_small":"2","columns_medium":0,"columns_large":0,"columns_xlarge":0,"panel":"blank","animation":"none","image_width":"auto","image_height":"auto","media_align":"teaser","media_width":"1-2","media_breakpoint":"medium","content_align":true,"nav":"none","nav_overlay":true,"nav_align":"center","thumbnail_width":"70","thumbnail_height":"70","slidenav":"default","nav_contrast":true,"slide_animation":"fade","slices":"15","duration":"500","autoplay":false,"interval":"3000","autoplay_pause":true,"kenburns":false,"title":false,"content":false,"title_size":"panel","text_align":"left","link":false,"link_style":"button","link_text":"Read more","badge":true,"badge_style":"badge","badge_position":"panel","link_target":false,"class":"tm-margin-condensed"}},"items":[{"title":"Marketing","media":"images\\/yootheme\\/widgetkit\\/single-more-01.jpg","width":"1280","height":"667","options":{"media":{"width":1280,"height":667},"media2":{"width":1280,"height":667},"media3":{"width":1280,"height":667}},"content":"Another happy client.","link":"index.php\\/work\\/portfolio","media2":"images\\/yootheme\\/widgetkit\\/single-more-02.jpg","media3":"images\\/yootheme\\/widgetkit\\/single-more-03.jpg"},{"media":"images\\/yootheme\\/widgetkit\\/single-more-04.jpg","options":{"media":{"width":1280,"height":667},"media2":{"width":1280,"height":667},"media3":{"width":1280,"height":667}},"title":"Brandings","content":"Another happy client.","media2":"images\\/yootheme\\/widgetkit\\/single-more-05.jpg","media3":"images\\/yootheme\\/widgetkit\\/single-more-06.jpg","link":"index.php\\/work\\/portfolio"}],"_fields":[{"name":"media2","type":"media","label":"Media 2","core":true},{"label":"Media 3","name":"media3","type":"media"}]}'),
(114, 'Theme Widgets', 'custom', '{"_widget":{"name":"grid-stack","data":{"width":"1-2","align":"left","breakpoint":"medium","alternate":true,"gutter":true,"gutter_vertical":"default","divider":true,"panel":true,"content_align":true,"animation_media":"fade","animation_content":"fade","media":true,"image_width":"auto","image_height":"auto","media_border":"none","media_overlay":"none","overlay_animation":"fade","media_animation":"scale","title":true,"content":true,"social_buttons":true,"title_size":"h2","text_align":"left","link":true,"link_style":"button","link_text":"Read more","badge":true,"badge_style":"badge","badge_position":"panel","link_target":false,"class":""}},"items":[{"media":"images\\/yootheme\\/features_widgets_slideshow.gif","options":{"media":{"width":900,"height":620}},"title":"Slideshow Avanti","content":"<p>Avanti comes with a modified Slideshow widget which works perfectly inside the theme''s <strong>header<\\/strong> layout position.<\\/p>\\n\\n<h4 class=\\"uk-h6\\">Specials<\\/h4>\\n<ul class=\\"uk-list uk-list-line uk-list-space\\">\\n<li>Pure CSS Numnav option to navigate between the slides.<\\/li>\\n<li>The overlay layout uses the same container width as the theme.<\\/li>\\n<li>Overlay content width for medium to large view ports can be set to 50%, 66%, 75% and 100% of the container.<\\/li>\\n<li>Overlay content position can be set to <em>Center<\\/em>, <em>Center left<\\/em> and <em>Center right<\\/em>.<\\/li>\\n<li>Animate Letters option for the slideshow item title.<\\/li>\\n<\\/ul>"},{"media":"images\\/yootheme\\/features_widgets_slideshow-panel.gif","options":{"media":{"width":900,"height":620}},"title":"Slideshow Panel Avanti","content":"<p>With the Widgetkit 2.5 release we have added the Slideshow Panel. Avanti uses a slightly modified version perfectly fitting for any portfolio, case study or product presentation.<\\/p>\\n\\n<h4 class=\\"uk-h6\\">Specials<\\/h4>\\n<ul class=\\"uk-list uk-list-line uk-list-space\\">\\n<li><strong>Content max width<\\/strong> - Will set a maximum width for the content on large view ports.<\\/li>\\n<li>The badge is separated from the content and is displayed above the media item.<\\/li>\\n<\\/ul>"},{"media":"images\\/yootheme\\/features_widgets_grid.gif","options":{"media":{"width":900,"height":620}},"title":"Grid Avanti","content":"<p>For Avanti we have added a modified grid widget to customize our output, especially the one we can not control at all, like WordPress\\/Joomla system content. We have added a truncate option for the title and the content which makes it easier to control the data output and height.<\\/p>\\n\\n<h4 class=\\"uk-h6\\">Specials<\\/h4>\\n<ul class=\\"uk-list uk-list-line uk-list-space\\">\\n<li>Truncation option for the item title and content.<\\/li>\\n<li>Grid divider option displays a border between the items.<\\/li>\\n<li>Panel Horizontal to add more spacing between items, recommend in combination with the grid divider.<\\/li>\\n<li>Badge muted to display a badge with a subtle background color. <em>(depends on the theme style)<\\/em><\\/li>\\n<li>Option to display article\\/post tags as badges.<\\/li>\\n<\\/ul>"}],"_fields":[]}'),
(115, 'Widgetkit Theme Widgets', 'custom', '{"_widget":{"name":"grid","data":{"grid":"default","gutter":"default","gutter_dynamic":"20","gutter_v_dynamic":"","filter":"none","filter_align":"left","filter_all":true,"columns":"1","columns_small":"0","columns_medium":"3","columns_large":"0","columns_xlarge":"0","panel":"box","panel_link":false,"animation":"scale-up","media":true,"image_width":"auto","image_height":"auto","media_align":"top","media_width":"1-2","media_breakpoint":"medium","content_align":true,"media_border":"none","media_overlay":"none","overlay_animation":"fade","media_animation":"scale","title":true,"content":true,"social_buttons":true,"title_size":"h4","text_align":"center","link":true,"link_style":"button","link_text":"Read more","badge":true,"badge_style":"badge","badge_position":"panel","link_target":false,"class":""}},"items":[{"title":"Slideshow Avanti","media":"images\\/yootheme\\/widget_slideshow_avanti.svg","width":"","options":{"media":{"width":40,"height":40}}},{"media":"images\\/yootheme\\/widget_slideshow-panel_avanti.svg","title":"Slideshow Panel Avanti","options":{"media":{"width":40,"height":40}}},{"title":"Grid Avanti","media":"images\\/yootheme\\/widget_grid_avanti.svg","width":"","options":{"media":{"width":40,"height":40}}}],"_fields":[]}');

--
-- Indizes der exportierten Tabellen
--

--
-- Indizes für die Tabelle `#__assets`
--
ALTER TABLE `#__assets`
 ADD PRIMARY KEY (`id`), ADD UNIQUE KEY `idx_asset_name` (`name`), ADD KEY `idx_lft_rgt` (`lft`,`rgt`), ADD KEY `idx_parent_id` (`parent_id`);

--
-- Indizes für die Tabelle `#__associations`
--
ALTER TABLE `#__categories`
 ADD PRIMARY KEY (`id`), ADD KEY `cat_idx` (`extension`,`published`,`access`), ADD KEY `idx_access` (`access`), ADD KEY `idx_checkout` (`checked_out`), ADD KEY `idx_path` (`path`), ADD KEY `idx_left_right` (`lft`,`rgt`), ADD KEY `idx_alias` (`alias`), ADD KEY `idx_language` (`language`);

--
-- Indizes für die Tabelle `#__contact_details`
--
ALTER TABLE `#__contact_details`
 ADD PRIMARY KEY (`id`), ADD KEY `idx_access` (`access`), ADD KEY `idx_checkout` (`checked_out`), ADD KEY `idx_state` (`published`), ADD KEY `idx_catid` (`catid`), ADD KEY `idx_createdby` (`created_by`), ADD KEY `idx_featured_catid` (`featured`,`catid`), ADD KEY `idx_language` (`language`), ADD KEY `idx_xreference` (`xreference`);

--
-- Indizes für die Tabelle `#__content`
--
ALTER TABLE `#__content`
 ADD PRIMARY KEY (`id`), ADD KEY `idx_access` (`access`), ADD KEY `idx_checkout` (`checked_out`), ADD KEY `idx_state` (`state`), ADD KEY `idx_catid` (`catid`), ADD KEY `idx_createdby` (`created_by`), ADD KEY `idx_featured_catid` (`featured`,`catid`), ADD KEY `idx_language` (`language`), ADD KEY `idx_xreference` (`xreference`);

--
-- Indizes für die Tabelle `#__contentitem_tag_map`
--
ALTER TABLE `#__contentitem_tag_map`
 ADD UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`), ADD KEY `idx_tag_type` (`tag_id`,`type_id`), ADD KEY `idx_date_id` (`tag_date`,`tag_id`), ADD KEY `idx_tag` (`tag_id`), ADD KEY `idx_type` (`type_id`), ADD KEY `idx_core_content_id` (`core_content_id`);

--
-- Indizes für die Tabelle `#__content_frontpage`
--
ALTER TABLE `#__content_frontpage`
 ADD PRIMARY KEY (`content_id`);

--
-- Indizes für die Tabelle `#__content_rating`
--
ALTER TABLE `#__extensions`
 ADD PRIMARY KEY (`extension_id`), ADD KEY `element_clientid` (`element`,`client_id`), ADD KEY `element_folder_clientid` (`element`,`folder`,`client_id`), ADD KEY `extension` (`type`,`element`,`folder`,`client_id`);

--
-- Indizes für die Tabelle `#__finder_filters`
--
ALTER TABLE `#__menu`
 ADD PRIMARY KEY (`id`), ADD UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`,`language`), ADD KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`), ADD KEY `idx_menutype` (`menutype`), ADD KEY `idx_left_right` (`lft`,`rgt`), ADD KEY `idx_alias` (`alias`), ADD KEY `idx_path` (`path`(255)), ADD KEY `idx_language` (`language`);

--
-- Indizes für die Tabelle `#__menu_types`
--
ALTER TABLE `#__menu_types`
 ADD PRIMARY KEY (`id`), ADD UNIQUE KEY `idx_menutype` (`menutype`);

--
-- Indizes für die Tabelle `#__messages`
--
ALTER TABLE `#__modules`
 ADD PRIMARY KEY (`id`), ADD KEY `published` (`published`,`access`), ADD KEY `newsfeeds` (`module`,`published`), ADD KEY `idx_language` (`language`);

--
-- Indizes für die Tabelle `#__modules_menu`
--
ALTER TABLE `#__modules_menu`
 ADD PRIMARY KEY (`moduleid`,`menuid`);

--
-- Indizes für die Tabelle `#__newsfeeds`
--
ALTER TABLE `#__tags`
 ADD PRIMARY KEY (`id`), ADD KEY `tag_idx` (`published`,`access`), ADD KEY `idx_access` (`access`), ADD KEY `idx_checkout` (`checked_out`), ADD KEY `idx_path` (`path`), ADD KEY `idx_left_right` (`lft`,`rgt`), ADD KEY `idx_alias` (`alias`), ADD KEY `idx_language` (`language`);

--
-- Indizes für die Tabelle `#__template_styles`
--
ALTER TABLE `#__template_styles`
 ADD PRIMARY KEY (`id`), ADD KEY `idx_template` (`template`), ADD KEY `idx_home` (`home`);

--
-- Indizes für die Tabelle `#__ucm_base`
--
ALTER TABLE `#__ucm_base`
 ADD PRIMARY KEY (`ucm_id`), ADD KEY `idx_ucm_item_id` (`ucm_item_id`), ADD KEY `idx_ucm_type_id` (`ucm_type_id`), ADD KEY `idx_ucm_language_id` (`ucm_language_id`);

--
-- Indizes für die Tabelle `#__ucm_content`
--
ALTER TABLE `#__ucm_content`
 ADD PRIMARY KEY (`core_content_id`), ADD KEY `tag_idx` (`core_state`,`core_access`), ADD KEY `idx_access` (`core_access`), ADD KEY `idx_alias` (`core_alias`), ADD KEY `idx_language` (`core_language`), ADD KEY `idx_title` (`core_title`), ADD KEY `idx_modified_time` (`core_modified_time`), ADD KEY `idx_created_time` (`core_created_time`), ADD KEY `idx_content_type` (`core_type_alias`), ADD KEY `idx_core_modified_user_id` (`core_modified_user_id`), ADD KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`), ADD KEY `idx_core_created_user_id` (`core_created_user_id`), ADD KEY `idx_core_type_id` (`core_type_id`);

--
-- Indizes für die Tabelle `#__ucm_history`
--
ALTER TABLE `#__widgetkit`
 ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT für exportierte Tabellen
--

--
-- AUTO_INCREMENT für Tabelle `#__assets`
--
ALTER TABLE `#__assets`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',AUTO_INCREMENT=374;
--
-- AUTO_INCREMENT für Tabelle `#__banners`
--
ALTER TABLE `#__categories`
MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=12;
--
-- AUTO_INCREMENT für Tabelle `#__contact_details`
--
ALTER TABLE `#__contact_details`
MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT für Tabelle `#__content`
--
ALTER TABLE `#__content`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=61;
--
-- AUTO_INCREMENT für Tabelle `#__content_types`
--
ALTER TABLE `#__extensions`
MODIFY `extension_id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=10032;
--
-- AUTO_INCREMENT für Tabelle `#__finder_filters`
--
ALTER TABLE `#__menu`
MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=272;
--
-- AUTO_INCREMENT für Tabelle `#__menu_types`
--
ALTER TABLE `#__menu_types`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=5;
--
-- AUTO_INCREMENT für Tabelle `#__messages`
--
ALTER TABLE `#__modules`
MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=267;
--
-- AUTO_INCREMENT für Tabelle `#__newsfeeds`
--
ALTER TABLE `#__tags`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=28;
--
-- AUTO_INCREMENT für Tabelle `#__template_styles`
--
ALTER TABLE `#__template_styles`
MODIFY `id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=11;
--
-- AUTO_INCREMENT für Tabelle `#__ucm_content`
--
ALTER TABLE `#__ucm_content`
MODIFY `core_content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=23;
--
-- AUTO_INCREMENT für Tabelle `#__ucm_history`
--
ALTER TABLE `#__widgetkit`
MODIFY `id` int(10) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=116;
